// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class TrainedModelTreeNodeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNode>
{
	private static readonly System.Text.Json.JsonEncodedText PropDecisionType = System.Text.Json.JsonEncodedText.Encode("decision_type");
	private static readonly System.Text.Json.JsonEncodedText PropDefaultLeft = System.Text.Json.JsonEncodedText.Encode("default_left");
	private static readonly System.Text.Json.JsonEncodedText PropLeafValue = System.Text.Json.JsonEncodedText.Encode("leaf_value");
	private static readonly System.Text.Json.JsonEncodedText PropLeftChild = System.Text.Json.JsonEncodedText.Encode("left_child");
	private static readonly System.Text.Json.JsonEncodedText PropNodeIndex = System.Text.Json.JsonEncodedText.Encode("node_index");
	private static readonly System.Text.Json.JsonEncodedText PropRightChild = System.Text.Json.JsonEncodedText.Encode("right_child");
	private static readonly System.Text.Json.JsonEncodedText PropSplitFeature = System.Text.Json.JsonEncodedText.Encode("split_feature");
	private static readonly System.Text.Json.JsonEncodedText PropSplitGain = System.Text.Json.JsonEncodedText.Encode("split_gain");
	private static readonly System.Text.Json.JsonEncodedText PropThreshold = System.Text.Json.JsonEncodedText.Encode("threshold");

	public override Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNode Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propDecisionType = default;
		LocalJsonValue<bool?> propDefaultLeft = default;
		LocalJsonValue<double?> propLeafValue = default;
		LocalJsonValue<int?> propLeftChild = default;
		LocalJsonValue<int> propNodeIndex = default;
		LocalJsonValue<int?> propRightChild = default;
		LocalJsonValue<int?> propSplitFeature = default;
		LocalJsonValue<int?> propSplitGain = default;
		LocalJsonValue<double?> propThreshold = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propDecisionType.TryReadProperty(ref reader, options, PropDecisionType, null))
			{
				continue;
			}

			if (propDefaultLeft.TryReadProperty(ref reader, options, PropDefaultLeft, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propLeafValue.TryReadProperty(ref reader, options, PropLeafValue, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propLeftChild.TryReadProperty(ref reader, options, PropLeftChild, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propNodeIndex.TryReadProperty(ref reader, options, PropNodeIndex, null))
			{
				continue;
			}

			if (propRightChild.TryReadProperty(ref reader, options, PropRightChild, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propSplitFeature.TryReadProperty(ref reader, options, PropSplitFeature, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propSplitGain.TryReadProperty(ref reader, options, PropSplitGain, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propThreshold.TryReadProperty(ref reader, options, PropThreshold, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNode(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			DecisionType = propDecisionType.Value,
			DefaultLeft = propDefaultLeft.Value,
			LeafValue = propLeafValue.Value,
			LeftChild = propLeftChild.Value,
			NodeIndex = propNodeIndex.Value,
			RightChild = propRightChild.Value,
			SplitFeature = propSplitFeature.Value,
			SplitGain = propSplitGain.Value,
			Threshold = propThreshold.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNode value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropDecisionType, value.DecisionType, null, null);
		writer.WriteProperty(options, PropDefaultLeft, value.DefaultLeft, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropLeafValue, value.LeafValue, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropLeftChild, value.LeftChild, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropNodeIndex, value.NodeIndex, null, null);
		writer.WriteProperty(options, PropRightChild, value.RightChild, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropSplitFeature, value.SplitFeature, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropSplitGain, value.SplitGain, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropThreshold, value.Threshold, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteEndObject();
	}
}