// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.TrainedModelTreeConverter))]
public sealed partial class TrainedModelTree
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TrainedModelTree(System.Collections.Generic.ICollection<string> featureNames, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNode> treeStructure)
	{
		FeatureNames = featureNames;
		TreeStructure = treeStructure;
	}
#if NET7_0_OR_GREATER
	public TrainedModelTree()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public TrainedModelTree()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TrainedModelTree(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public System.Collections.Generic.ICollection<string>? ClassificationLabels { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<string> FeatureNames { get; set; }
	public string? TargetType { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNode> TreeStructure { get; set; }
}

public readonly partial struct TrainedModelTreeDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTree Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TrainedModelTreeDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTree instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TrainedModelTreeDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTree(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTree instance) => new Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTree(Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeDescriptor ClassificationLabels(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.ClassificationLabels = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeDescriptor ClassificationLabels(params string[] values)
	{
		Instance.ClassificationLabels = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeDescriptor FeatureNames(System.Collections.Generic.ICollection<string> value)
	{
		Instance.FeatureNames = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeDescriptor FeatureNames(params string[] values)
	{
		Instance.FeatureNames = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeDescriptor TargetType(string? value)
	{
		Instance.TargetType = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeDescriptor TreeStructure(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNode> value)
	{
		Instance.TreeStructure = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeDescriptor TreeStructure(params Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNode[] values)
	{
		Instance.TreeStructure = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeDescriptor TreeStructure(params System.Action<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNodeDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNode>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNodeDescriptor.Build(action));
		}

		Instance.TreeStructure = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTree Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTree(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}