// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.TrainedModelStatsConverter))]
public sealed partial class TrainedModelStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TrainedModelStats(string modelId, Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelSizeStats modelSizeStats, int pipelineCount)
	{
		ModelId = modelId;
		ModelSizeStats = modelSizeStats;
		PipelineCount = pipelineCount;
	}
#if NET7_0_OR_GREATER
	public TrainedModelStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public TrainedModelStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TrainedModelStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A collection of deployment stats, which is present when the models are deployed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDeploymentStats? DeploymentStats { get; set; }

	/// <summary>
	/// <para>
	/// A collection of inference stats fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelInferenceStats? InferenceStats { get; set; }

	/// <summary>
	/// <para>
	/// A collection of ingest stats for the model across all nodes.
	/// The values are summations of the individual node statistics.
	/// The format matches the ingest section in the nodes stats API.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyDictionary<string, object>? Ingest { get; set; }

	/// <summary>
	/// <para>
	/// The unique identifier of the trained model.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ModelId { get; set; }

	/// <summary>
	/// <para>
	/// A collection of model size stats.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelSizeStats ModelSizeStats { get; set; }

	/// <summary>
	/// <para>
	/// The number of ingest pipelines that currently refer to the model.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int PipelineCount { get; set; }
}