// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class TrainedModelStatsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelStats>
{
	private static readonly System.Text.Json.JsonEncodedText PropDeploymentStats = System.Text.Json.JsonEncodedText.Encode("deployment_stats");
	private static readonly System.Text.Json.JsonEncodedText PropInferenceStats = System.Text.Json.JsonEncodedText.Encode("inference_stats");
	private static readonly System.Text.Json.JsonEncodedText PropIngest = System.Text.Json.JsonEncodedText.Encode("ingest");
	private static readonly System.Text.Json.JsonEncodedText PropModelId = System.Text.Json.JsonEncodedText.Encode("model_id");
	private static readonly System.Text.Json.JsonEncodedText PropModelSizeStats = System.Text.Json.JsonEncodedText.Encode("model_size_stats");
	private static readonly System.Text.Json.JsonEncodedText PropPipelineCount = System.Text.Json.JsonEncodedText.Encode("pipeline_count");

	public override Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelStats Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDeploymentStats?> propDeploymentStats = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelInferenceStats?> propInferenceStats = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, object>?> propIngest = default;
		LocalJsonValue<string> propModelId = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelSizeStats> propModelSizeStats = default;
		LocalJsonValue<int> propPipelineCount = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propDeploymentStats.TryReadProperty(ref reader, options, PropDeploymentStats, null))
			{
				continue;
			}

			if (propInferenceStats.TryReadProperty(ref reader, options, PropInferenceStats, null))
			{
				continue;
			}

			if (propIngest.TryReadProperty(ref reader, options, PropIngest, static System.Collections.Generic.IReadOnlyDictionary<string, object>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, object>(o, null, static object (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<object>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.SourceMarker<object>))!)))
			{
				continue;
			}

			if (propModelId.TryReadProperty(ref reader, options, PropModelId, null))
			{
				continue;
			}

			if (propModelSizeStats.TryReadProperty(ref reader, options, PropModelSizeStats, null))
			{
				continue;
			}

			if (propPipelineCount.TryReadProperty(ref reader, options, PropPipelineCount, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			DeploymentStats = propDeploymentStats.Value,
			InferenceStats = propInferenceStats.Value,
			Ingest = propIngest.Value,
			ModelId = propModelId.Value,
			ModelSizeStats = propModelSizeStats.Value,
			PipelineCount = propPipelineCount.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelStats value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropDeploymentStats, value.DeploymentStats, null, null);
		writer.WriteProperty(options, PropInferenceStats, value.InferenceStats, null, null);
		writer.WriteProperty(options, PropIngest, value.Ingest, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, object>? v) => w.WriteDictionaryValue<string, object>(o, v, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, object v) => w.WriteValueEx<object>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.SourceMarker<object>))));
		writer.WriteProperty(options, PropModelId, value.ModelId, null, null);
		writer.WriteProperty(options, PropModelSizeStats, value.ModelSizeStats, null, null);
		writer.WriteProperty(options, PropPipelineCount, value.PipelineCount, null, null);
		writer.WriteEndObject();
	}
}