// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.TrainedModelInferenceStatsConverter))]
public sealed partial class TrainedModelInferenceStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TrainedModelInferenceStats(int cacheMissCount, int failureCount, int inferenceCount, int missingAllFieldsCount, System.DateTimeOffset timestamp)
	{
		CacheMissCount = cacheMissCount;
		FailureCount = failureCount;
		InferenceCount = inferenceCount;
		MissingAllFieldsCount = missingAllFieldsCount;
		Timestamp = timestamp;
	}
#if NET7_0_OR_GREATER
	public TrainedModelInferenceStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public TrainedModelInferenceStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TrainedModelInferenceStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The number of times the model was loaded for inference and was not retrieved from the cache.
	/// If this number is close to the <c>inference_count</c>, the cache is not being appropriately used.
	/// This can be solved by increasing the cache size or its time-to-live (TTL).
	/// Refer to general machine learning settings for the appropriate settings.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int CacheMissCount { get; set; }

	/// <summary>
	/// <para>
	/// The number of failures when using the model for inference.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int FailureCount { get; set; }

	/// <summary>
	/// <para>
	/// The total number of times the model has been called for inference.
	/// This is across all inference contexts, including all pipelines.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int InferenceCount { get; set; }

	/// <summary>
	/// <para>
	/// The number of inference calls where all the training features for the model were missing.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int MissingAllFieldsCount { get; set; }

	/// <summary>
	/// <para>
	/// The time when the statistics were last updated.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.DateTimeOffset Timestamp { get; set; }
}