// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class TrainedModelInferenceStatsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelInferenceStats>
{
	private static readonly System.Text.Json.JsonEncodedText PropCacheMissCount = System.Text.Json.JsonEncodedText.Encode("cache_miss_count");
	private static readonly System.Text.Json.JsonEncodedText PropFailureCount = System.Text.Json.JsonEncodedText.Encode("failure_count");
	private static readonly System.Text.Json.JsonEncodedText PropInferenceCount = System.Text.Json.JsonEncodedText.Encode("inference_count");
	private static readonly System.Text.Json.JsonEncodedText PropMissingAllFieldsCount = System.Text.Json.JsonEncodedText.Encode("missing_all_fields_count");
	private static readonly System.Text.Json.JsonEncodedText PropTimestamp = System.Text.Json.JsonEncodedText.Encode("timestamp");

	public override Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelInferenceStats Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<int> propCacheMissCount = default;
		LocalJsonValue<int> propFailureCount = default;
		LocalJsonValue<int> propInferenceCount = default;
		LocalJsonValue<int> propMissingAllFieldsCount = default;
		LocalJsonValue<System.DateTimeOffset> propTimestamp = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propCacheMissCount.TryReadProperty(ref reader, options, PropCacheMissCount, null))
			{
				continue;
			}

			if (propFailureCount.TryReadProperty(ref reader, options, PropFailureCount, null))
			{
				continue;
			}

			if (propInferenceCount.TryReadProperty(ref reader, options, PropInferenceCount, null))
			{
				continue;
			}

			if (propMissingAllFieldsCount.TryReadProperty(ref reader, options, PropMissingAllFieldsCount, null))
			{
				continue;
			}

			if (propTimestamp.TryReadProperty(ref reader, options, PropTimestamp, static System.DateTimeOffset (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.DateTimeOffset>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker))))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelInferenceStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			CacheMissCount = propCacheMissCount.Value,
			FailureCount = propFailureCount.Value,
			InferenceCount = propInferenceCount.Value,
			MissingAllFieldsCount = propMissingAllFieldsCount.Value,
			Timestamp = propTimestamp.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelInferenceStats value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropCacheMissCount, value.CacheMissCount, null, null);
		writer.WriteProperty(options, PropFailureCount, value.FailureCount, null, null);
		writer.WriteProperty(options, PropInferenceCount, value.InferenceCount, null, null);
		writer.WriteProperty(options, PropMissingAllFieldsCount, value.MissingAllFieldsCount, null, null);
		writer.WriteProperty(options, PropTimestamp, value.Timestamp, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.DateTimeOffset v) => w.WriteValueEx<System.DateTimeOffset>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker)));
		writer.WriteEndObject();
	}
}