// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class TrainedModelEntitiesConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelEntities>
{
	private static readonly System.Text.Json.JsonEncodedText PropClassName = System.Text.Json.JsonEncodedText.Encode("class_name");
	private static readonly System.Text.Json.JsonEncodedText PropClassProbability = System.Text.Json.JsonEncodedText.Encode("class_probability");
	private static readonly System.Text.Json.JsonEncodedText PropEndPos = System.Text.Json.JsonEncodedText.Encode("end_pos");
	private static readonly System.Text.Json.JsonEncodedText PropEntity = System.Text.Json.JsonEncodedText.Encode("entity");
	private static readonly System.Text.Json.JsonEncodedText PropStartPos = System.Text.Json.JsonEncodedText.Encode("start_pos");

	public override Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelEntities Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string> propClassName = default;
		LocalJsonValue<double> propClassProbability = default;
		LocalJsonValue<int> propEndPos = default;
		LocalJsonValue<string> propEntity = default;
		LocalJsonValue<int> propStartPos = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propClassName.TryReadProperty(ref reader, options, PropClassName, null))
			{
				continue;
			}

			if (propClassProbability.TryReadProperty(ref reader, options, PropClassProbability, null))
			{
				continue;
			}

			if (propEndPos.TryReadProperty(ref reader, options, PropEndPos, null))
			{
				continue;
			}

			if (propEntity.TryReadProperty(ref reader, options, PropEntity, null))
			{
				continue;
			}

			if (propStartPos.TryReadProperty(ref reader, options, PropStartPos, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelEntities(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			ClassName = propClassName.Value,
			ClassProbability = propClassProbability.Value,
			EndPos = propEndPos.Value,
			Entity = propEntity.Value,
			StartPos = propStartPos.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelEntities value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropClassName, value.ClassName, null, null);
		writer.WriteProperty(options, PropClassProbability, value.ClassProbability, null, null);
		writer.WriteProperty(options, PropEndPos, value.EndPos, null, null);
		writer.WriteProperty(options, PropEntity, value.Entity, null, null);
		writer.WriteProperty(options, PropStartPos, value.StartPos, null, null);
		writer.WriteEndObject();
	}
}