// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.TrainedModelDeploymentStatsConverter))]
public sealed partial class TrainedModelDeploymentStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TrainedModelDeploymentStats(string deploymentId, string modelId, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDeploymentNodesStats> nodes, long peakThroughputPerMinute, Elastic.Clients.Elasticsearch.MachineLearning.TrainingPriority priority, System.DateTimeOffset startTime)
	{
		DeploymentId = deploymentId;
		ModelId = modelId;
		Nodes = nodes;
		PeakThroughputPerMinute = peakThroughputPerMinute;
		Priority = priority;
		StartTime = startTime;
	}
#if NET7_0_OR_GREATER
	public TrainedModelDeploymentStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public TrainedModelDeploymentStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TrainedModelDeploymentStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.AdaptiveAllocationsSettings? AdaptiveAllocations { get; set; }

	/// <summary>
	/// <para>
	/// The detailed allocation status for the deployment.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDeploymentAllocationStatus? AllocationStatus { get; set; }
	public Elastic.Clients.Elasticsearch.ByteSize? CacheSize { get; set; }

	/// <summary>
	/// <para>
	/// The unique identifier for the trained model deployment.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string DeploymentId { get; set; }

	/// <summary>
	/// <para>
	/// The sum of <c>error_count</c> for all nodes in the deployment.
	/// </para>
	/// </summary>
	public int? ErrorCount { get; set; }

	/// <summary>
	/// <para>
	/// The sum of <c>inference_count</c> for all nodes in the deployment.
	/// </para>
	/// </summary>
	public int? InferenceCount { get; set; }

	/// <summary>
	/// <para>
	/// The unique identifier for the trained model.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ModelId { get; set; }

	/// <summary>
	/// <para>
	/// The deployment stats for each node that currently has the model allocated.
	/// In serverless, stats are reported for a single unnamed virtual node.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDeploymentNodesStats> Nodes { get; set; }

	/// <summary>
	/// <para>
	/// The number of allocations requested.
	/// </para>
	/// </summary>
	public int? NumberOfAllocations { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long PeakThroughputPerMinute { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.TrainingPriority Priority { get; set; }

	/// <summary>
	/// <para>
	/// The number of inference requests that can be queued before new requests are rejected.
	/// </para>
	/// </summary>
	public int? QueueCapacity { get; set; }

	/// <summary>
	/// <para>
	/// The reason for the current deployment state. Usually only populated when
	/// the model is not deployed to a node.
	/// </para>
	/// </summary>
	public string? Reason { get; set; }

	/// <summary>
	/// <para>
	/// The sum of <c>rejected_execution_count</c> for all nodes in the deployment.
	/// Individual nodes reject an inference request if the inference queue is full.
	/// The queue size is controlled by the <c>queue_capacity</c> setting in the start
	/// trained model deployment API.
	/// </para>
	/// </summary>
	public int? RejectedExecutionCount { get; set; }

	/// <summary>
	/// <para>
	/// The epoch timestamp when the deployment started.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.DateTimeOffset StartTime { get; set; }

	/// <summary>
	/// <para>
	/// The overall state of the deployment.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DeploymentAssignmentState? State { get; set; }

	/// <summary>
	/// <para>
	/// The number of threads used be each allocation during inference.
	/// </para>
	/// </summary>
	public int? ThreadsPerAllocation { get; set; }

	/// <summary>
	/// <para>
	/// The sum of <c>timeout_count</c> for all nodes in the deployment.
	/// </para>
	/// </summary>
	public int? TimeoutCount { get; set; }
}