// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class TrainedModelDeploymentStatsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDeploymentStats>
{
	private static readonly System.Text.Json.JsonEncodedText PropAdaptiveAllocations = System.Text.Json.JsonEncodedText.Encode("adaptive_allocations");
	private static readonly System.Text.Json.JsonEncodedText PropAllocationStatus = System.Text.Json.JsonEncodedText.Encode("allocation_status");
	private static readonly System.Text.Json.JsonEncodedText PropCacheSize = System.Text.Json.JsonEncodedText.Encode("cache_size");
	private static readonly System.Text.Json.JsonEncodedText PropDeploymentId = System.Text.Json.JsonEncodedText.Encode("deployment_id");
	private static readonly System.Text.Json.JsonEncodedText PropErrorCount = System.Text.Json.JsonEncodedText.Encode("error_count");
	private static readonly System.Text.Json.JsonEncodedText PropInferenceCount = System.Text.Json.JsonEncodedText.Encode("inference_count");
	private static readonly System.Text.Json.JsonEncodedText PropModelId = System.Text.Json.JsonEncodedText.Encode("model_id");
	private static readonly System.Text.Json.JsonEncodedText PropNodes = System.Text.Json.JsonEncodedText.Encode("nodes");
	private static readonly System.Text.Json.JsonEncodedText PropNumberOfAllocations = System.Text.Json.JsonEncodedText.Encode("number_of_allocations");
	private static readonly System.Text.Json.JsonEncodedText PropPeakThroughputPerMinute = System.Text.Json.JsonEncodedText.Encode("peak_throughput_per_minute");
	private static readonly System.Text.Json.JsonEncodedText PropPriority = System.Text.Json.JsonEncodedText.Encode("priority");
	private static readonly System.Text.Json.JsonEncodedText PropQueueCapacity = System.Text.Json.JsonEncodedText.Encode("queue_capacity");
	private static readonly System.Text.Json.JsonEncodedText PropReason = System.Text.Json.JsonEncodedText.Encode("reason");
	private static readonly System.Text.Json.JsonEncodedText PropRejectedExecutionCount = System.Text.Json.JsonEncodedText.Encode("rejected_execution_count");
	private static readonly System.Text.Json.JsonEncodedText PropStartTime = System.Text.Json.JsonEncodedText.Encode("start_time");
	private static readonly System.Text.Json.JsonEncodedText PropState = System.Text.Json.JsonEncodedText.Encode("state");
	private static readonly System.Text.Json.JsonEncodedText PropThreadsPerAllocation = System.Text.Json.JsonEncodedText.Encode("threads_per_allocation");
	private static readonly System.Text.Json.JsonEncodedText PropTimeoutCount = System.Text.Json.JsonEncodedText.Encode("timeout_count");

	public override Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDeploymentStats Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.AdaptiveAllocationsSettings?> propAdaptiveAllocations = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDeploymentAllocationStatus?> propAllocationStatus = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propCacheSize = default;
		LocalJsonValue<string> propDeploymentId = default;
		LocalJsonValue<int?> propErrorCount = default;
		LocalJsonValue<int?> propInferenceCount = default;
		LocalJsonValue<string> propModelId = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDeploymentNodesStats>> propNodes = default;
		LocalJsonValue<int?> propNumberOfAllocations = default;
		LocalJsonValue<long> propPeakThroughputPerMinute = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.TrainingPriority> propPriority = default;
		LocalJsonValue<int?> propQueueCapacity = default;
		LocalJsonValue<string?> propReason = default;
		LocalJsonValue<int?> propRejectedExecutionCount = default;
		LocalJsonValue<System.DateTimeOffset> propStartTime = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.DeploymentAssignmentState?> propState = default;
		LocalJsonValue<int?> propThreadsPerAllocation = default;
		LocalJsonValue<int?> propTimeoutCount = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAdaptiveAllocations.TryReadProperty(ref reader, options, PropAdaptiveAllocations, null))
			{
				continue;
			}

			if (propAllocationStatus.TryReadProperty(ref reader, options, PropAllocationStatus, null))
			{
				continue;
			}

			if (propCacheSize.TryReadProperty(ref reader, options, PropCacheSize, null))
			{
				continue;
			}

			if (propDeploymentId.TryReadProperty(ref reader, options, PropDeploymentId, null))
			{
				continue;
			}

			if (propErrorCount.TryReadProperty(ref reader, options, PropErrorCount, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propInferenceCount.TryReadProperty(ref reader, options, PropInferenceCount, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propModelId.TryReadProperty(ref reader, options, PropModelId, null))
			{
				continue;
			}

			if (propNodes.TryReadProperty(ref reader, options, PropNodes, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDeploymentNodesStats> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDeploymentNodesStats>(o, null)!))
			{
				continue;
			}

			if (propNumberOfAllocations.TryReadProperty(ref reader, options, PropNumberOfAllocations, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propPeakThroughputPerMinute.TryReadProperty(ref reader, options, PropPeakThroughputPerMinute, null))
			{
				continue;
			}

			if (propPriority.TryReadProperty(ref reader, options, PropPriority, null))
			{
				continue;
			}

			if (propQueueCapacity.TryReadProperty(ref reader, options, PropQueueCapacity, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propReason.TryReadProperty(ref reader, options, PropReason, null))
			{
				continue;
			}

			if (propRejectedExecutionCount.TryReadProperty(ref reader, options, PropRejectedExecutionCount, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propStartTime.TryReadProperty(ref reader, options, PropStartTime, static System.DateTimeOffset (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.DateTimeOffset>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker))))
			{
				continue;
			}

			if (propState.TryReadProperty(ref reader, options, PropState, static Elastic.Clients.Elasticsearch.MachineLearning.DeploymentAssignmentState? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<Elastic.Clients.Elasticsearch.MachineLearning.DeploymentAssignmentState>(o)))
			{
				continue;
			}

			if (propThreadsPerAllocation.TryReadProperty(ref reader, options, PropThreadsPerAllocation, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propTimeoutCount.TryReadProperty(ref reader, options, PropTimeoutCount, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDeploymentStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			AdaptiveAllocations = propAdaptiveAllocations.Value,
			AllocationStatus = propAllocationStatus.Value,
			CacheSize = propCacheSize.Value,
			DeploymentId = propDeploymentId.Value,
			ErrorCount = propErrorCount.Value,
			InferenceCount = propInferenceCount.Value,
			ModelId = propModelId.Value,
			Nodes = propNodes.Value,
			NumberOfAllocations = propNumberOfAllocations.Value,
			PeakThroughputPerMinute = propPeakThroughputPerMinute.Value,
			Priority = propPriority.Value,
			QueueCapacity = propQueueCapacity.Value,
			Reason = propReason.Value,
			RejectedExecutionCount = propRejectedExecutionCount.Value,
			StartTime = propStartTime.Value,
			State = propState.Value,
			ThreadsPerAllocation = propThreadsPerAllocation.Value,
			TimeoutCount = propTimeoutCount.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDeploymentStats value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAdaptiveAllocations, value.AdaptiveAllocations, null, null);
		writer.WriteProperty(options, PropAllocationStatus, value.AllocationStatus, null, null);
		writer.WriteProperty(options, PropCacheSize, value.CacheSize, null, null);
		writer.WriteProperty(options, PropDeploymentId, value.DeploymentId, null, null);
		writer.WriteProperty(options, PropErrorCount, value.ErrorCount, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropInferenceCount, value.InferenceCount, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropModelId, value.ModelId, null, null);
		writer.WriteProperty(options, PropNodes, value.Nodes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDeploymentNodesStats> v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDeploymentNodesStats>(o, v, null));
		writer.WriteProperty(options, PropNumberOfAllocations, value.NumberOfAllocations, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropPeakThroughputPerMinute, value.PeakThroughputPerMinute, null, null);
		writer.WriteProperty(options, PropPriority, value.Priority, null, null);
		writer.WriteProperty(options, PropQueueCapacity, value.QueueCapacity, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropReason, value.Reason, null, null);
		writer.WriteProperty(options, PropRejectedExecutionCount, value.RejectedExecutionCount, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropStartTime, value.StartTime, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.DateTimeOffset v) => w.WriteValueEx<System.DateTimeOffset>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker)));
		writer.WriteProperty(options, PropState, value.State, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.MachineLearning.DeploymentAssignmentState? v) => w.WriteNullableValue<Elastic.Clients.Elasticsearch.MachineLearning.DeploymentAssignmentState>(o, v));
		writer.WriteProperty(options, PropThreadsPerAllocation, value.ThreadsPerAllocation, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropTimeoutCount, value.TimeoutCount, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteEndObject();
	}
}