// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.TrainedModelDeploymentNodesStatsConverter))]
public sealed partial class TrainedModelDeploymentNodesStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TrainedModelDeploymentNodesStats(long peakThroughputPerMinute, Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelAssignmentRoutingStateAndReason routingState, int throughputLastMinute)
	{
		PeakThroughputPerMinute = peakThroughputPerMinute;
		RoutingState = routingState;
		ThroughputLastMinute = throughputLastMinute;
	}
#if NET7_0_OR_GREATER
	public TrainedModelDeploymentNodesStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public TrainedModelDeploymentNodesStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TrainedModelDeploymentNodesStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The average time for each inference call to complete on this node.
	/// </para>
	/// </summary>
	public System.TimeSpan? AverageInferenceTimeMs { get; set; }

	/// <summary>
	/// <para>
	/// The average time for each inference call to complete on this node, excluding cache
	/// </para>
	/// </summary>
	public System.TimeSpan? AverageInferenceTimeMsExcludingCacheHits { get; set; }
	public System.TimeSpan? AverageInferenceTimeMsLastMinute { get; set; }

	/// <summary>
	/// <para>
	/// The number of errors when evaluating the trained model.
	/// </para>
	/// </summary>
	public int? ErrorCount { get; set; }
	public long? InferenceCacheHitCount { get; set; }
	public long? InferenceCacheHitCountLastMinute { get; set; }

	/// <summary>
	/// <para>
	/// The total number of inference calls made against this node for this model.
	/// </para>
	/// </summary>
	public long? InferenceCount { get; set; }

	/// <summary>
	/// <para>
	/// The epoch time stamp of the last inference call for the model on this node.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? LastAccess { get; set; }

	/// <summary>
	/// <para>
	/// Information pertaining to the node.
	/// </para>
	/// </summary>
	public System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.MachineLearning.DiscoveryNodeContent>? Node { get; set; }

	/// <summary>
	/// <para>
	/// The number of allocations assigned to this node.
	/// </para>
	/// </summary>
	public int? NumberOfAllocations { get; set; }

	/// <summary>
	/// <para>
	/// The number of inference requests queued to be processed.
	/// </para>
	/// </summary>
	public int? NumberOfPendingRequests { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long PeakThroughputPerMinute { get; set; }

	/// <summary>
	/// <para>
	/// The number of inference requests that were not processed because the queue was full.
	/// </para>
	/// </summary>
	public int? RejectedExecutionCount { get; set; }

	/// <summary>
	/// <para>
	/// The current routing state and reason for the current routing state for this allocation.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelAssignmentRoutingStateAndReason RoutingState { get; set; }

	/// <summary>
	/// <para>
	/// The epoch timestamp when the allocation started.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? StartTime { get; set; }

	/// <summary>
	/// <para>
	/// The number of threads used by each allocation during inference.
	/// </para>
	/// </summary>
	public int? ThreadsPerAllocation { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	int ThroughputLastMinute { get; set; }

	/// <summary>
	/// <para>
	/// The number of inference requests that timed out before being processed.
	/// </para>
	/// </summary>
	public int? TimeoutCount { get; set; }
}