// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class TrainedModelDeploymentNodesStatsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDeploymentNodesStats>
{
	private static readonly System.Text.Json.JsonEncodedText PropAverageInferenceTimeMs = System.Text.Json.JsonEncodedText.Encode("average_inference_time_ms");
	private static readonly System.Text.Json.JsonEncodedText PropAverageInferenceTimeMsExcludingCacheHits = System.Text.Json.JsonEncodedText.Encode("average_inference_time_ms_excluding_cache_hits");
	private static readonly System.Text.Json.JsonEncodedText PropAverageInferenceTimeMsLastMinute = System.Text.Json.JsonEncodedText.Encode("average_inference_time_ms_last_minute");
	private static readonly System.Text.Json.JsonEncodedText PropErrorCount = System.Text.Json.JsonEncodedText.Encode("error_count");
	private static readonly System.Text.Json.JsonEncodedText PropInferenceCacheHitCount = System.Text.Json.JsonEncodedText.Encode("inference_cache_hit_count");
	private static readonly System.Text.Json.JsonEncodedText PropInferenceCacheHitCountLastMinute = System.Text.Json.JsonEncodedText.Encode("inference_cache_hit_count_last_minute");
	private static readonly System.Text.Json.JsonEncodedText PropInferenceCount = System.Text.Json.JsonEncodedText.Encode("inference_count");
	private static readonly System.Text.Json.JsonEncodedText PropLastAccess = System.Text.Json.JsonEncodedText.Encode("last_access");
	private static readonly System.Text.Json.JsonEncodedText PropNode = System.Text.Json.JsonEncodedText.Encode("node");
	private static readonly System.Text.Json.JsonEncodedText PropNumberOfAllocations = System.Text.Json.JsonEncodedText.Encode("number_of_allocations");
	private static readonly System.Text.Json.JsonEncodedText PropNumberOfPendingRequests = System.Text.Json.JsonEncodedText.Encode("number_of_pending_requests");
	private static readonly System.Text.Json.JsonEncodedText PropPeakThroughputPerMinute = System.Text.Json.JsonEncodedText.Encode("peak_throughput_per_minute");
	private static readonly System.Text.Json.JsonEncodedText PropRejectedExecutionCount = System.Text.Json.JsonEncodedText.Encode("rejected_execution_count");
	private static readonly System.Text.Json.JsonEncodedText PropRoutingState = System.Text.Json.JsonEncodedText.Encode("routing_state");
	private static readonly System.Text.Json.JsonEncodedText PropStartTime = System.Text.Json.JsonEncodedText.Encode("start_time");
	private static readonly System.Text.Json.JsonEncodedText PropThreadsPerAllocation = System.Text.Json.JsonEncodedText.Encode("threads_per_allocation");
	private static readonly System.Text.Json.JsonEncodedText PropThroughputLastMinute = System.Text.Json.JsonEncodedText.Encode("throughput_last_minute");
	private static readonly System.Text.Json.JsonEncodedText PropTimeoutCount = System.Text.Json.JsonEncodedText.Encode("timeout_count");

	public override Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDeploymentNodesStats Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<System.TimeSpan?> propAverageInferenceTimeMs = default;
		LocalJsonValue<System.TimeSpan?> propAverageInferenceTimeMsExcludingCacheHits = default;
		LocalJsonValue<System.TimeSpan?> propAverageInferenceTimeMsLastMinute = default;
		LocalJsonValue<int?> propErrorCount = default;
		LocalJsonValue<long?> propInferenceCacheHitCount = default;
		LocalJsonValue<long?> propInferenceCacheHitCountLastMinute = default;
		LocalJsonValue<long?> propInferenceCount = default;
		LocalJsonValue<System.DateTimeOffset?> propLastAccess = default;
		LocalJsonValue<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.MachineLearning.DiscoveryNodeContent>?> propNode = default;
		LocalJsonValue<int?> propNumberOfAllocations = default;
		LocalJsonValue<int?> propNumberOfPendingRequests = default;
		LocalJsonValue<long> propPeakThroughputPerMinute = default;
		LocalJsonValue<int?> propRejectedExecutionCount = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelAssignmentRoutingStateAndReason> propRoutingState = default;
		LocalJsonValue<System.DateTimeOffset?> propStartTime = default;
		LocalJsonValue<int?> propThreadsPerAllocation = default;
		LocalJsonValue<int> propThroughputLastMinute = default;
		LocalJsonValue<int?> propTimeoutCount = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAverageInferenceTimeMs.TryReadProperty(ref reader, options, PropAverageInferenceTimeMs, static System.TimeSpan? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker))))
			{
				continue;
			}

			if (propAverageInferenceTimeMsExcludingCacheHits.TryReadProperty(ref reader, options, PropAverageInferenceTimeMsExcludingCacheHits, static System.TimeSpan? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker))))
			{
				continue;
			}

			if (propAverageInferenceTimeMsLastMinute.TryReadProperty(ref reader, options, PropAverageInferenceTimeMsLastMinute, static System.TimeSpan? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker))))
			{
				continue;
			}

			if (propErrorCount.TryReadProperty(ref reader, options, PropErrorCount, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propInferenceCacheHitCount.TryReadProperty(ref reader, options, PropInferenceCacheHitCount, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propInferenceCacheHitCountLastMinute.TryReadProperty(ref reader, options, PropInferenceCacheHitCountLastMinute, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propInferenceCount.TryReadProperty(ref reader, options, PropInferenceCount, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propLastAccess.TryReadProperty(ref reader, options, PropLastAccess, static System.DateTimeOffset? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValueEx<System.DateTimeOffset>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker))))
			{
				continue;
			}

			if (propNode.TryReadProperty(ref reader, options, PropNode, static System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.MachineLearning.DiscoveryNodeContent>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadKeyValuePairValue<string, Elastic.Clients.Elasticsearch.MachineLearning.DiscoveryNodeContent>(o, null, null)))
			{
				continue;
			}

			if (propNumberOfAllocations.TryReadProperty(ref reader, options, PropNumberOfAllocations, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propNumberOfPendingRequests.TryReadProperty(ref reader, options, PropNumberOfPendingRequests, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propPeakThroughputPerMinute.TryReadProperty(ref reader, options, PropPeakThroughputPerMinute, null))
			{
				continue;
			}

			if (propRejectedExecutionCount.TryReadProperty(ref reader, options, PropRejectedExecutionCount, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propRoutingState.TryReadProperty(ref reader, options, PropRoutingState, null))
			{
				continue;
			}

			if (propStartTime.TryReadProperty(ref reader, options, PropStartTime, static System.DateTimeOffset? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValueEx<System.DateTimeOffset>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker))))
			{
				continue;
			}

			if (propThreadsPerAllocation.TryReadProperty(ref reader, options, PropThreadsPerAllocation, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propThroughputLastMinute.TryReadProperty(ref reader, options, PropThroughputLastMinute, null))
			{
				continue;
			}

			if (propTimeoutCount.TryReadProperty(ref reader, options, PropTimeoutCount, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDeploymentNodesStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			AverageInferenceTimeMs = propAverageInferenceTimeMs.Value,
			AverageInferenceTimeMsExcludingCacheHits = propAverageInferenceTimeMsExcludingCacheHits.Value,
			AverageInferenceTimeMsLastMinute = propAverageInferenceTimeMsLastMinute.Value,
			ErrorCount = propErrorCount.Value,
			InferenceCacheHitCount = propInferenceCacheHitCount.Value,
			InferenceCacheHitCountLastMinute = propInferenceCacheHitCountLastMinute.Value,
			InferenceCount = propInferenceCount.Value,
			LastAccess = propLastAccess.Value,
			Node = propNode.Value,
			NumberOfAllocations = propNumberOfAllocations.Value,
			NumberOfPendingRequests = propNumberOfPendingRequests.Value,
			PeakThroughputPerMinute = propPeakThroughputPerMinute.Value,
			RejectedExecutionCount = propRejectedExecutionCount.Value,
			RoutingState = propRoutingState.Value,
			StartTime = propStartTime.Value,
			ThreadsPerAllocation = propThreadsPerAllocation.Value,
			ThroughputLastMinute = propThroughputLastMinute.Value,
			TimeoutCount = propTimeoutCount.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDeploymentNodesStats value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAverageInferenceTimeMs, value.AverageInferenceTimeMs, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan? v) => w.WriteNullableValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker)));
		writer.WriteProperty(options, PropAverageInferenceTimeMsExcludingCacheHits, value.AverageInferenceTimeMsExcludingCacheHits, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan? v) => w.WriteNullableValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker)));
		writer.WriteProperty(options, PropAverageInferenceTimeMsLastMinute, value.AverageInferenceTimeMsLastMinute, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan? v) => w.WriteNullableValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker)));
		writer.WriteProperty(options, PropErrorCount, value.ErrorCount, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropInferenceCacheHitCount, value.InferenceCacheHitCount, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropInferenceCacheHitCountLastMinute, value.InferenceCacheHitCountLastMinute, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropInferenceCount, value.InferenceCount, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropLastAccess, value.LastAccess, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.DateTimeOffset? v) => w.WriteNullableValueEx<System.DateTimeOffset>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker)));
		writer.WriteProperty(options, PropNode, value.Node, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.MachineLearning.DiscoveryNodeContent>? v) => w.WriteKeyValuePairValue<string, Elastic.Clients.Elasticsearch.MachineLearning.DiscoveryNodeContent>(o, v, null, null));
		writer.WriteProperty(options, PropNumberOfAllocations, value.NumberOfAllocations, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropNumberOfPendingRequests, value.NumberOfPendingRequests, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropPeakThroughputPerMinute, value.PeakThroughputPerMinute, null, null);
		writer.WriteProperty(options, PropRejectedExecutionCount, value.RejectedExecutionCount, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropRoutingState, value.RoutingState, null, null);
		writer.WriteProperty(options, PropStartTime, value.StartTime, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.DateTimeOffset? v) => w.WriteNullableValueEx<System.DateTimeOffset>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker)));
		writer.WriteProperty(options, PropThreadsPerAllocation, value.ThreadsPerAllocation, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropThroughputLastMinute, value.ThroughputLastMinute, null, null);
		writer.WriteProperty(options, PropTimeoutCount, value.TimeoutCount, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteEndObject();
	}
}