// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.TrainedModelAssignmentTaskParametersConverter))]
public sealed partial class TrainedModelAssignmentTaskParameters
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TrainedModelAssignmentTaskParameters(string deploymentId, Elastic.Clients.Elasticsearch.ByteSize modelBytes, string modelId, int numberOfAllocations, Elastic.Clients.Elasticsearch.ByteSize perAllocationMemoryBytes, Elastic.Clients.Elasticsearch.ByteSize perDeploymentMemoryBytes, Elastic.Clients.Elasticsearch.MachineLearning.TrainingPriority priority, int queueCapacity, int threadsPerAllocation)
	{
		DeploymentId = deploymentId;
		ModelBytes = modelBytes;
		ModelId = modelId;
		NumberOfAllocations = numberOfAllocations;
		PerAllocationMemoryBytes = perAllocationMemoryBytes;
		PerDeploymentMemoryBytes = perDeploymentMemoryBytes;
		Priority = priority;
		QueueCapacity = queueCapacity;
		ThreadsPerAllocation = threadsPerAllocation;
	}
#if NET7_0_OR_GREATER
	public TrainedModelAssignmentTaskParameters()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public TrainedModelAssignmentTaskParameters()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TrainedModelAssignmentTaskParameters(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The size of the trained model cache.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? CacheSize { get; set; }

	/// <summary>
	/// <para>
	/// The unique identifier for the trained model deployment.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string DeploymentId { get; set; }

	/// <summary>
	/// <para>
	/// The size of the trained model in bytes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.ByteSize ModelBytes { get; set; }

	/// <summary>
	/// <para>
	/// The unique identifier for the trained model.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ModelId { get; set; }

	/// <summary>
	/// <para>
	/// The total number of allocations this model is assigned across ML nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int NumberOfAllocations { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.ByteSize PerAllocationMemoryBytes { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.ByteSize PerDeploymentMemoryBytes { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.TrainingPriority Priority { get; set; }

	/// <summary>
	/// <para>
	/// Number of inference requests are allowed in the queue at a time.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int QueueCapacity { get; set; }

	/// <summary>
	/// <para>
	/// Number of threads per allocation.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int ThreadsPerAllocation { get; set; }
}