// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.TrainedModelAssignmentRoutingTableConverter))]
public sealed partial class TrainedModelAssignmentRoutingTable
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TrainedModelAssignmentRoutingTable(int currentAllocations, Elastic.Clients.Elasticsearch.MachineLearning.RoutingState routingState, int targetAllocations)
	{
		CurrentAllocations = currentAllocations;
		RoutingState = routingState;
		TargetAllocations = targetAllocations;
	}
#if NET7_0_OR_GREATER
	public TrainedModelAssignmentRoutingTable()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public TrainedModelAssignmentRoutingTable()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TrainedModelAssignmentRoutingTable(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Current number of allocations.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int CurrentAllocations { get; set; }

	/// <summary>
	/// <para>
	/// The reason for the current state. It is usually populated only when the
	/// <c>routing_state</c> is <c>failed</c>.
	/// </para>
	/// </summary>
	public string? Reason { get; set; }

	/// <summary>
	/// <para>
	/// The current routing state.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.RoutingState RoutingState { get; set; }

	/// <summary>
	/// <para>
	/// Target number of allocations.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int TargetAllocations { get; set; }
}