// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class TrainedModelAssignmentConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelAssignment>
{
	private static readonly System.Text.Json.JsonEncodedText PropAdaptiveAllocations = System.Text.Json.JsonEncodedText.Encode("adaptive_allocations");
	private static readonly System.Text.Json.JsonEncodedText PropAssignmentState = System.Text.Json.JsonEncodedText.Encode("assignment_state");
	private static readonly System.Text.Json.JsonEncodedText PropMaxAssignedAllocations = System.Text.Json.JsonEncodedText.Encode("max_assigned_allocations");
	private static readonly System.Text.Json.JsonEncodedText PropReason = System.Text.Json.JsonEncodedText.Encode("reason");
	private static readonly System.Text.Json.JsonEncodedText PropRoutingTable = System.Text.Json.JsonEncodedText.Encode("routing_table");
	private static readonly System.Text.Json.JsonEncodedText PropStartTime = System.Text.Json.JsonEncodedText.Encode("start_time");
	private static readonly System.Text.Json.JsonEncodedText PropTaskParameters = System.Text.Json.JsonEncodedText.Encode("task_parameters");

	public override Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelAssignment Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.AdaptiveAllocationsSettings?> propAdaptiveAllocations = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.DeploymentAssignmentState> propAssignmentState = default;
		LocalJsonValue<int?> propMaxAssignedAllocations = default;
		LocalJsonValue<string?> propReason = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelAssignmentRoutingTable>> propRoutingTable = default;
		LocalJsonValue<System.DateTimeOffset> propStartTime = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelAssignmentTaskParameters> propTaskParameters = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAdaptiveAllocations.TryReadProperty(ref reader, options, PropAdaptiveAllocations, null))
			{
				continue;
			}

			if (propAssignmentState.TryReadProperty(ref reader, options, PropAssignmentState, null))
			{
				continue;
			}

			if (propMaxAssignedAllocations.TryReadProperty(ref reader, options, PropMaxAssignedAllocations, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propReason.TryReadProperty(ref reader, options, PropReason, null))
			{
				continue;
			}

			if (propRoutingTable.TryReadProperty(ref reader, options, PropRoutingTable, static System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelAssignmentRoutingTable> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelAssignmentRoutingTable>(o, null, null)!))
			{
				continue;
			}

			if (propStartTime.TryReadProperty(ref reader, options, PropStartTime, static System.DateTimeOffset (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.DateTimeOffset>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMarker))))
			{
				continue;
			}

			if (propTaskParameters.TryReadProperty(ref reader, options, PropTaskParameters, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelAssignment(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			AdaptiveAllocations = propAdaptiveAllocations.Value,
			AssignmentState = propAssignmentState.Value,
			MaxAssignedAllocations = propMaxAssignedAllocations.Value,
			Reason = propReason.Value,
			RoutingTable = propRoutingTable.Value,
			StartTime = propStartTime.Value,
			TaskParameters = propTaskParameters.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelAssignment value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAdaptiveAllocations, value.AdaptiveAllocations, null, null);
		writer.WriteProperty(options, PropAssignmentState, value.AssignmentState, null, null);
		writer.WriteProperty(options, PropMaxAssignedAllocations, value.MaxAssignedAllocations, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropReason, value.Reason, null, null);
		writer.WriteProperty(options, PropRoutingTable, value.RoutingTable, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelAssignmentRoutingTable> v) => w.WriteDictionaryValue<string, Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelAssignmentRoutingTable>(o, v, null, null));
		writer.WriteProperty(options, PropStartTime, value.StartTime, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.DateTimeOffset v) => w.WriteValueEx<System.DateTimeOffset>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMarker)));
		writer.WriteProperty(options, PropTaskParameters, value.TaskParameters, null, null);
		writer.WriteEndObject();
	}
}