// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.TrainedModelConverter))]
public sealed partial class TrainedModel
{
#if NET7_0_OR_GREATER
	public TrainedModel()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public TrainedModel()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TrainedModel(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The definition for an ensemble model
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.Ensemble? Ensemble { get; set; }

	/// <summary>
	/// <para>
	/// The definition for a binary decision tree.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTree? Tree { get; set; }

	/// <summary>
	/// <para>
	/// The definition of a node in a tree.
	/// There are two major types of nodes: leaf nodes and not-leaf nodes.
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// Leaf nodes only need node_index and leaf_value defined.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// All other nodes need split_feature, left_child, right_child, threshold, decision_type, and default_left defined.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNode? TreeNode { get; set; }
}

public readonly partial struct TrainedModelDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.TrainedModel Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TrainedModelDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.TrainedModel instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TrainedModelDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.TrainedModel(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.TrainedModel instance) => new Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.TrainedModel(Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The definition for an ensemble model
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDescriptor Ensemble(Elastic.Clients.Elasticsearch.MachineLearning.Ensemble? value)
	{
		Instance.Ensemble = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The definition for an ensemble model
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDescriptor Ensemble(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.EnsembleDescriptor> action)
	{
		Instance.Ensemble = Elastic.Clients.Elasticsearch.MachineLearning.EnsembleDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The definition for a binary decision tree.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDescriptor Tree(Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTree? value)
	{
		Instance.Tree = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The definition for a binary decision tree.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDescriptor Tree(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeDescriptor> action)
	{
		Instance.Tree = Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The definition of a node in a tree.
	/// There are two major types of nodes: leaf nodes and not-leaf nodes.
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// Leaf nodes only need node_index and leaf_value defined.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// All other nodes need split_feature, left_child, right_child, threshold, decision_type, and default_left defined.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDescriptor TreeNode(Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNode? value)
	{
		Instance.TreeNode = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The definition of a node in a tree.
	/// There are two major types of nodes: leaf nodes and not-leaf nodes.
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// Leaf nodes only need node_index and leaf_value defined.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// All other nodes need split_feature, left_child, right_child, threshold, decision_type, and default_left defined.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDescriptor TreeNode(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNodeDescriptor> action)
	{
		Instance.TreeNode = Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelTreeNodeDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.TrainedModel Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.MachineLearning.TrainedModel(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.TrainedModel(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}