// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.TokenizationConfigConverter))]
public sealed partial class TokenizationConfig
{
	internal string? VariantType { get; set; }
	internal object? Variant { get; set; }
#if NET7_0_OR_GREATER
	public TokenizationConfig()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public TokenizationConfig()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TokenizationConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Indicates BERT tokenization and its options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfig? Bert { get => GetVariant<Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfig>("bert"); set => SetVariant("bert", value); }

	/// <summary>
	/// <para>
	/// Indicates BERT Japanese tokenization and its options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfig? BertJa { get => GetVariant<Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfig>("bert_ja"); set => SetVariant("bert_ja", value); }

	/// <summary>
	/// <para>
	/// Indicates MPNET tokenization and its options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfig? Mpnet { get => GetVariant<Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfig>("mpnet"); set => SetVariant("mpnet", value); }

	/// <summary>
	/// <para>
	/// Indicates RoBERTa tokenization and its options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.NlpRobertaTokenizationConfig? Roberta { get => GetVariant<Elastic.Clients.Elasticsearch.MachineLearning.NlpRobertaTokenizationConfig>("roberta"); set => SetVariant("roberta", value); }
	public Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfig? XlmRoberta { get => GetVariant<Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfig>("xlm_roberta"); set => SetVariant("xlm_roberta", value); }

	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig(Elastic.Clients.Elasticsearch.MachineLearning.NlpRobertaTokenizationConfig value) => new Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig { Roberta = value };
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig(Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfig value) => new Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig { XlmRoberta = value };

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private T? GetVariant<T>(string type)
	{
		if (string.Equals(VariantType, type, System.StringComparison.Ordinal) && Variant is T result)
		{
			return result;
		}

		return default;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private void SetVariant<T>(string type, T? value)
	{
		VariantType = type;
		Variant = value;
	}
}

public readonly partial struct TokenizationConfigDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TokenizationConfigDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TokenizationConfigDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig instance) => new Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig(Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Indicates BERT tokenization and its options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor Bert(Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfig? value)
	{
		Instance.Bert = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates BERT tokenization and its options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor Bert()
	{
		Instance.Bert = Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfigDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates BERT tokenization and its options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor Bert(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfigDescriptor>? action)
	{
		Instance.Bert = Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfigDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates BERT Japanese tokenization and its options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor BertJa(Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfig? value)
	{
		Instance.BertJa = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates BERT Japanese tokenization and its options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor BertJa()
	{
		Instance.BertJa = Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfigDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates BERT Japanese tokenization and its options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor BertJa(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfigDescriptor>? action)
	{
		Instance.BertJa = Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfigDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates MPNET tokenization and its options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor Mpnet(Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfig? value)
	{
		Instance.Mpnet = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates MPNET tokenization and its options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor Mpnet()
	{
		Instance.Mpnet = Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfigDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates MPNET tokenization and its options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor Mpnet(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfigDescriptor>? action)
	{
		Instance.Mpnet = Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfigDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates RoBERTa tokenization and its options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor Roberta(Elastic.Clients.Elasticsearch.MachineLearning.NlpRobertaTokenizationConfig? value)
	{
		Instance.Roberta = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates RoBERTa tokenization and its options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor Roberta()
	{
		Instance.Roberta = Elastic.Clients.Elasticsearch.MachineLearning.NlpRobertaTokenizationConfigDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates RoBERTa tokenization and its options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor Roberta(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.NlpRobertaTokenizationConfigDescriptor>? action)
	{
		Instance.Roberta = Elastic.Clients.Elasticsearch.MachineLearning.NlpRobertaTokenizationConfigDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor XlmRoberta(Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfig? value)
	{
		Instance.XlmRoberta = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor XlmRoberta()
	{
		Instance.XlmRoberta = Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfigDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor XlmRoberta(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfigDescriptor>? action)
	{
		Instance.XlmRoberta = Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfigDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}