// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class TokenizationConfigConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig>
{
	private static readonly System.Text.Json.JsonEncodedText VariantBert = System.Text.Json.JsonEncodedText.Encode("bert");
	private static readonly System.Text.Json.JsonEncodedText VariantBertJa = System.Text.Json.JsonEncodedText.Encode("bert_ja");
	private static readonly System.Text.Json.JsonEncodedText VariantMpnet = System.Text.Json.JsonEncodedText.Encode("mpnet");
	private static readonly System.Text.Json.JsonEncodedText VariantRoberta = System.Text.Json.JsonEncodedText.Encode("roberta");
	private static readonly System.Text.Json.JsonEncodedText VariantXlmRoberta = System.Text.Json.JsonEncodedText.Encode("xlm_roberta");

	public override Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		string? variantType = null;
		object? variant = null;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (reader.ValueTextEquals(VariantBert))
			{
				variantType = VariantBert.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfig>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantBertJa))
			{
				variantType = VariantBertJa.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfig>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantMpnet))
			{
				variantType = VariantMpnet.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfig>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantRoberta))
			{
				variantType = VariantRoberta.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.MachineLearning.NlpRobertaTokenizationConfig>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantXlmRoberta))
			{
				variantType = VariantXlmRoberta.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfig>(options, null);
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			VariantType = variantType,
			Variant = variant
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		switch (value.VariantType)
		{
			case null:
				break;
			case "bert":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfig)value.Variant, null, null);
				break;
			case "bert_ja":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfig)value.Variant, null, null);
				break;
			case "mpnet":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.MachineLearning.NlpBertTokenizationConfig)value.Variant, null, null);
				break;
			case "roberta":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.MachineLearning.NlpRobertaTokenizationConfig)value.Variant, null, null);
				break;
			case "xlm_roberta":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.MachineLearning.XlmRobertaTokenizationConfig)value.Variant, null, null);
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.VariantType}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig)}'.");
		}

		writer.WriteEndObject();
	}
}