// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

/// <summary>
/// <para>
/// Text embedding inference options
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.TextEmbeddingInferenceOptionsConverter))]
public sealed partial class TextEmbeddingInferenceOptions
{
#if NET7_0_OR_GREATER
	public TextEmbeddingInferenceOptions()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public TextEmbeddingInferenceOptions()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TextEmbeddingInferenceOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The number of dimensions in the embedding output
	/// </para>
	/// </summary>
	public int? EmbeddingSize { get; set; }

	/// <summary>
	/// <para>
	/// The field that is added to incoming documents to contain the inference prediction. Defaults to predicted_value.
	/// </para>
	/// </summary>
	public string? ResultsField { get; set; }

	/// <summary>
	/// <para>
	/// The tokenization options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig? Tokenization { get; set; }
	public Elastic.Clients.Elasticsearch.MachineLearning.Vocabulary? Vocabulary { get; set; }
}

/// <summary>
/// <para>
/// Text embedding inference options
/// </para>
/// </summary>
public readonly partial struct TextEmbeddingInferenceOptionsDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.TextEmbeddingInferenceOptions Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TextEmbeddingInferenceOptionsDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.TextEmbeddingInferenceOptions instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TextEmbeddingInferenceOptionsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.TextEmbeddingInferenceOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.TextEmbeddingInferenceOptionsDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.TextEmbeddingInferenceOptions instance) => new Elastic.Clients.Elasticsearch.MachineLearning.TextEmbeddingInferenceOptionsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.TextEmbeddingInferenceOptions(Elastic.Clients.Elasticsearch.MachineLearning.TextEmbeddingInferenceOptionsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The number of dimensions in the embedding output
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TextEmbeddingInferenceOptionsDescriptor EmbeddingSize(int? value)
	{
		Instance.EmbeddingSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that is added to incoming documents to contain the inference prediction. Defaults to predicted_value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TextEmbeddingInferenceOptionsDescriptor ResultsField(string? value)
	{
		Instance.ResultsField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The tokenization options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TextEmbeddingInferenceOptionsDescriptor Tokenization(Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig? value)
	{
		Instance.Tokenization = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The tokenization options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TextEmbeddingInferenceOptionsDescriptor Tokenization(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor> action)
	{
		Instance.Tokenization = Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TextEmbeddingInferenceOptionsDescriptor Vocabulary(Elastic.Clients.Elasticsearch.MachineLearning.Vocabulary? value)
	{
		Instance.Vocabulary = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TextEmbeddingInferenceOptionsDescriptor Vocabulary(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.VocabularyDescriptor> action)
	{
		Instance.Vocabulary = Elastic.Clients.Elasticsearch.MachineLearning.VocabularyDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.TextEmbeddingInferenceOptions Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.TextEmbeddingInferenceOptionsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.MachineLearning.TextEmbeddingInferenceOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.TextEmbeddingInferenceOptionsDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.TextEmbeddingInferenceOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}