// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

/// <summary>
/// <para>
/// Text classification configuration options
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.TextClassificationInferenceOptionsConverter))]
public sealed partial class TextClassificationInferenceOptions
{
#if NET7_0_OR_GREATER
	public TextClassificationInferenceOptions()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public TextClassificationInferenceOptions()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TextClassificationInferenceOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Classification labels to apply other than the stored labels. Must have the same deminsions as the default configured labels
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? ClassificationLabels { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the number of top class predictions to return. Defaults to 0.
	/// </para>
	/// </summary>
	public int? NumTopClasses { get; set; }

	/// <summary>
	/// <para>
	/// The field that is added to incoming documents to contain the inference prediction. Defaults to predicted_value.
	/// </para>
	/// </summary>
	public string? ResultsField { get; set; }

	/// <summary>
	/// <para>
	/// The tokenization options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig? Tokenization { get; set; }
	public Elastic.Clients.Elasticsearch.MachineLearning.Vocabulary? Vocabulary { get; set; }
}

/// <summary>
/// <para>
/// Text classification configuration options
/// </para>
/// </summary>
public readonly partial struct TextClassificationInferenceOptionsDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.TextClassificationInferenceOptions Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TextClassificationInferenceOptionsDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.TextClassificationInferenceOptions instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TextClassificationInferenceOptionsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.TextClassificationInferenceOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.TextClassificationInferenceOptionsDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.TextClassificationInferenceOptions instance) => new Elastic.Clients.Elasticsearch.MachineLearning.TextClassificationInferenceOptionsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.TextClassificationInferenceOptions(Elastic.Clients.Elasticsearch.MachineLearning.TextClassificationInferenceOptionsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Classification labels to apply other than the stored labels. Must have the same deminsions as the default configured labels
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TextClassificationInferenceOptionsDescriptor ClassificationLabels(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.ClassificationLabels = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Classification labels to apply other than the stored labels. Must have the same deminsions as the default configured labels
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TextClassificationInferenceOptionsDescriptor ClassificationLabels(params string[] values)
	{
		Instance.ClassificationLabels = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the number of top class predictions to return. Defaults to 0.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TextClassificationInferenceOptionsDescriptor NumTopClasses(int? value)
	{
		Instance.NumTopClasses = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that is added to incoming documents to contain the inference prediction. Defaults to predicted_value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TextClassificationInferenceOptionsDescriptor ResultsField(string? value)
	{
		Instance.ResultsField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The tokenization options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TextClassificationInferenceOptionsDescriptor Tokenization(Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig? value)
	{
		Instance.Tokenization = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The tokenization options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TextClassificationInferenceOptionsDescriptor Tokenization(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor> action)
	{
		Instance.Tokenization = Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TextClassificationInferenceOptionsDescriptor Vocabulary(Elastic.Clients.Elasticsearch.MachineLearning.Vocabulary? value)
	{
		Instance.Vocabulary = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TextClassificationInferenceOptionsDescriptor Vocabulary(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.VocabularyDescriptor> action)
	{
		Instance.Vocabulary = Elastic.Clients.Elasticsearch.MachineLearning.VocabularyDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.TextClassificationInferenceOptions Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.TextClassificationInferenceOptionsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.MachineLearning.TextClassificationInferenceOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.TextClassificationInferenceOptionsDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.TextClassificationInferenceOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}