// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.TargetMeanEncodingPreprocessorConverter))]
public sealed partial class TargetMeanEncodingPreprocessor
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TargetMeanEncodingPreprocessor(double defaultValue, string featureName, string field, System.Collections.Generic.IDictionary<string, double> targetMap)
	{
		DefaultValue = defaultValue;
		FeatureName = featureName;
		Field = field;
		TargetMap = targetMap;
	}
#if NET7_0_OR_GREATER
	public TargetMeanEncodingPreprocessor()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public TargetMeanEncodingPreprocessor()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TargetMeanEncodingPreprocessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public
#if NET7_0_OR_GREATER
	required
#endif
	double DefaultValue { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string FeatureName { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Field { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IDictionary<string, double> TargetMap { get; set; }
}

public readonly partial struct TargetMeanEncodingPreprocessorDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TargetMeanEncodingPreprocessorDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TargetMeanEncodingPreprocessorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessorDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessor instance) => new Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessorDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessor(Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessorDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessorDescriptor DefaultValue(double value)
	{
		Instance.DefaultValue = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessorDescriptor FeatureName(string value)
	{
		Instance.FeatureName = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessorDescriptor Field(string value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessorDescriptor TargetMap(System.Collections.Generic.IDictionary<string, double> value)
	{
		Instance.TargetMap = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessorDescriptor TargetMap()
	{
		Instance.TargetMap = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringDouble.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessorDescriptor TargetMap(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringDouble>? action)
	{
		Instance.TargetMap = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringDouble.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessorDescriptor AddTargetMap(string key, double value)
	{
		Instance.TargetMap ??= new System.Collections.Generic.Dictionary<string, double>();
		Instance.TargetMap.Add(key, value);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessor Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessorDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessorDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}