// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class SnapshotUpgradeStateConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.SnapshotUpgradeState>
{
	private static readonly System.Text.Json.JsonEncodedText MemberFailed = System.Text.Json.JsonEncodedText.Encode("failed");
	private static readonly System.Text.Json.JsonEncodedText MemberLoadingOldState = System.Text.Json.JsonEncodedText.Encode("loading_old_state");
	private static readonly System.Text.Json.JsonEncodedText MemberSavingNewState = System.Text.Json.JsonEncodedText.Encode("saving_new_state");
	private static readonly System.Text.Json.JsonEncodedText MemberStopped = System.Text.Json.JsonEncodedText.Encode("stopped");

	public override Elastic.Clients.Elasticsearch.MachineLearning.SnapshotUpgradeState Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberFailed))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.SnapshotUpgradeState.Failed;
		}

		if (reader.ValueTextEquals(MemberLoadingOldState))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.SnapshotUpgradeState.LoadingOldState;
		}

		if (reader.ValueTextEquals(MemberSavingNewState))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.SnapshotUpgradeState.SavingNewState;
		}

		if (reader.ValueTextEquals(MemberStopped))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.SnapshotUpgradeState.Stopped;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberFailed.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.SnapshotUpgradeState.Failed;
		}

		if (string.Equals(value, MemberLoadingOldState.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.SnapshotUpgradeState.LoadingOldState;
		}

		if (string.Equals(value, MemberSavingNewState.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.SnapshotUpgradeState.SavingNewState;
		}

		if (string.Equals(value, MemberStopped.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.SnapshotUpgradeState.Stopped;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.SnapshotUpgradeState)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.SnapshotUpgradeState value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.MachineLearning.SnapshotUpgradeState.Failed:
				writer.WriteStringValue(MemberFailed);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.SnapshotUpgradeState.LoadingOldState:
				writer.WriteStringValue(MemberLoadingOldState);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.SnapshotUpgradeState.SavingNewState:
				writer.WriteStringValue(MemberSavingNewState);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.SnapshotUpgradeState.Stopped:
				writer.WriteStringValue(MemberStopped);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.SnapshotUpgradeState)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.MachineLearning.SnapshotUpgradeState ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.SnapshotUpgradeState value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}