// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.RuleConditionConverter))]
public sealed partial class RuleCondition
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RuleCondition(Elastic.Clients.Elasticsearch.MachineLearning.AppliesTo appliesTo, Elastic.Clients.Elasticsearch.MachineLearning.ConditionOperator @operator, double value)
	{
		AppliesTo = appliesTo;
		Operator = @operator;
		Value = value;
	}
#if NET7_0_OR_GREATER
	public RuleCondition()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public RuleCondition()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RuleCondition(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Specifies the result property to which the condition applies. If your detector uses <c>lat_long</c>, <c>metric</c>, <c>rare</c>, or <c>freq_rare</c> functions, you can only specify conditions that apply to time.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.AppliesTo AppliesTo { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the condition operator. The available options are greater than, greater than or equals, less than, and less than or equals.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.ConditionOperator Operator { get; set; }

	/// <summary>
	/// <para>
	/// The value that is compared against the <c>applies_to</c> field using the operator.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	double Value { get; set; }
}

public readonly partial struct RuleConditionDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.RuleCondition Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RuleConditionDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.RuleCondition instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RuleConditionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.RuleCondition(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.RuleConditionDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.RuleCondition instance) => new Elastic.Clients.Elasticsearch.MachineLearning.RuleConditionDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.RuleCondition(Elastic.Clients.Elasticsearch.MachineLearning.RuleConditionDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Specifies the result property to which the condition applies. If your detector uses <c>lat_long</c>, <c>metric</c>, <c>rare</c>, or <c>freq_rare</c> functions, you can only specify conditions that apply to time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.RuleConditionDescriptor AppliesTo(Elastic.Clients.Elasticsearch.MachineLearning.AppliesTo value)
	{
		Instance.AppliesTo = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the condition operator. The available options are greater than, greater than or equals, less than, and less than or equals.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.RuleConditionDescriptor Operator(Elastic.Clients.Elasticsearch.MachineLearning.ConditionOperator value)
	{
		Instance.Operator = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value that is compared against the <c>applies_to</c> field using the operator.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.RuleConditionDescriptor Value(double value)
	{
		Instance.Value = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.RuleCondition Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.RuleConditionDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.RuleConditionDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.RuleCondition(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}