// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class RuleActionConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.RuleAction>
{
	private static readonly System.Text.Json.JsonEncodedText MemberSkipModelUpdate = System.Text.Json.JsonEncodedText.Encode("skip_model_update");
	private static readonly System.Text.Json.JsonEncodedText MemberSkipResult = System.Text.Json.JsonEncodedText.Encode("skip_result");

	public override Elastic.Clients.Elasticsearch.MachineLearning.RuleAction Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberSkipModelUpdate))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.RuleAction.SkipModelUpdate;
		}

		if (reader.ValueTextEquals(MemberSkipResult))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.RuleAction.SkipResult;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberSkipModelUpdate.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.RuleAction.SkipModelUpdate;
		}

		if (string.Equals(value, MemberSkipResult.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.RuleAction.SkipResult;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.RuleAction)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.RuleAction value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.MachineLearning.RuleAction.SkipModelUpdate:
				writer.WriteStringValue(MemberSkipModelUpdate);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.RuleAction.SkipResult:
				writer.WriteStringValue(MemberSkipResult);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.RuleAction)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.MachineLearning.RuleAction ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.RuleAction value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}