// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.QueryFeatureExtractorConverter))]
public sealed partial class QueryFeatureExtractor
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryFeatureExtractor(string featureName, Elastic.Clients.Elasticsearch.QueryDsl.Query query)
	{
		FeatureName = featureName;
		Query = query;
	}
#if NET7_0_OR_GREATER
	public QueryFeatureExtractor()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public QueryFeatureExtractor()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal QueryFeatureExtractor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public float? DefaultScore { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string FeatureName { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryDsl.Query Query { get; set; }
}

public readonly partial struct QueryFeatureExtractorDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryFeatureExtractorDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryFeatureExtractorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractorDescriptor<TDocument>(Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractor instance) => new Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractorDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractor(Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractorDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractorDescriptor<TDocument> DefaultScore(float? value)
	{
		Instance.DefaultScore = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractorDescriptor<TDocument> FeatureName(string value)
	{
		Instance.FeatureName = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractorDescriptor<TDocument> Query(Elastic.Clients.Elasticsearch.QueryDsl.Query value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractorDescriptor<TDocument> Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractor Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractorDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractorDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct QueryFeatureExtractorDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryFeatureExtractorDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryFeatureExtractorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractorDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractor instance) => new Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractorDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractor(Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractorDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractorDescriptor DefaultScore(float? value)
	{
		Instance.DefaultScore = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractorDescriptor FeatureName(string value)
	{
		Instance.FeatureName = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractorDescriptor Query(Elastic.Clients.Elasticsearch.QueryDsl.Query value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractorDescriptor Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractorDescriptor Query<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractor Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractorDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractorDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}