// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.PreprocessorConverter))]
public sealed partial class Preprocessor
{
	internal string? VariantType { get; set; }
	internal object? Variant { get; set; }
#if NET7_0_OR_GREATER
	public Preprocessor()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public Preprocessor()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Preprocessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessor? FrequencyEncoding { get => GetVariant<Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessor>("frequency_encoding"); set => SetVariant("frequency_encoding", value); }
	public Elastic.Clients.Elasticsearch.MachineLearning.OneHotEncodingPreprocessor? OneHotEncoding { get => GetVariant<Elastic.Clients.Elasticsearch.MachineLearning.OneHotEncodingPreprocessor>("one_hot_encoding"); set => SetVariant("one_hot_encoding", value); }
	public Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessor? TargetMeanEncoding { get => GetVariant<Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessor>("target_mean_encoding"); set => SetVariant("target_mean_encoding", value); }

	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.Preprocessor(Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessor value) => new Elastic.Clients.Elasticsearch.MachineLearning.Preprocessor { FrequencyEncoding = value };
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.Preprocessor(Elastic.Clients.Elasticsearch.MachineLearning.OneHotEncodingPreprocessor value) => new Elastic.Clients.Elasticsearch.MachineLearning.Preprocessor { OneHotEncoding = value };
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.Preprocessor(Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessor value) => new Elastic.Clients.Elasticsearch.MachineLearning.Preprocessor { TargetMeanEncoding = value };

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private T? GetVariant<T>(string type)
	{
		if (string.Equals(VariantType, type, System.StringComparison.Ordinal) && Variant is T result)
		{
			return result;
		}

		return default;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private void SetVariant<T>(string type, T? value)
	{
		VariantType = type;
		Variant = value;
	}
}

public readonly partial struct PreprocessorDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.Preprocessor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PreprocessorDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.Preprocessor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PreprocessorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.Preprocessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.PreprocessorDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.Preprocessor instance) => new Elastic.Clients.Elasticsearch.MachineLearning.PreprocessorDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.Preprocessor(Elastic.Clients.Elasticsearch.MachineLearning.PreprocessorDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.MachineLearning.PreprocessorDescriptor FrequencyEncoding(Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessor? value)
	{
		Instance.FrequencyEncoding = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PreprocessorDescriptor FrequencyEncoding(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessorDescriptor> action)
	{
		Instance.FrequencyEncoding = Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessorDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PreprocessorDescriptor OneHotEncoding(Elastic.Clients.Elasticsearch.MachineLearning.OneHotEncodingPreprocessor? value)
	{
		Instance.OneHotEncoding = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PreprocessorDescriptor OneHotEncoding(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.OneHotEncodingPreprocessorDescriptor> action)
	{
		Instance.OneHotEncoding = Elastic.Clients.Elasticsearch.MachineLearning.OneHotEncodingPreprocessorDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PreprocessorDescriptor TargetMeanEncoding(Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessor? value)
	{
		Instance.TargetMeanEncoding = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PreprocessorDescriptor TargetMeanEncoding(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessorDescriptor> action)
	{
		Instance.TargetMeanEncoding = Elastic.Clients.Elasticsearch.MachineLearning.TargetMeanEncodingPreprocessorDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.Preprocessor Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PreprocessorDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PreprocessorDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.Preprocessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}