// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.PerPartitionCategorizationConverter))]
public sealed partial class PerPartitionCategorization
{
#if NET7_0_OR_GREATER
	public PerPartitionCategorization()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public PerPartitionCategorization()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PerPartitionCategorization(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// To enable this setting, you must also set the <c>partition_field_name</c> property to the same value in every detector that uses the keyword <c>mlcategory</c>. Otherwise, job creation fails.
	/// </para>
	/// </summary>
	public bool? Enabled { get; set; }

	/// <summary>
	/// <para>
	/// This setting can be set to true only if per-partition categorization is enabled. If true, both categorization and subsequent anomaly detection stops for partitions where the categorization status changes to warn. This setting makes it viable to have a job where it is expected that categorization works well for some partitions but not others; you do not pay the cost of bad categorization forever in the partitions where it works badly.
	/// </para>
	/// </summary>
	public bool? StopOnWarn { get; set; }
}

public readonly partial struct PerPartitionCategorizationDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorization Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PerPartitionCategorizationDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorization instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PerPartitionCategorizationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorization(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorizationDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorization instance) => new Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorizationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorization(Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorizationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// To enable this setting, you must also set the <c>partition_field_name</c> property to the same value in every detector that uses the keyword <c>mlcategory</c>. Otherwise, job creation fails.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorizationDescriptor Enabled(bool? value = true)
	{
		Instance.Enabled = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting can be set to true only if per-partition categorization is enabled. If true, both categorization and subsequent anomaly detection stops for partitions where the categorization status changes to warn. This setting makes it viable to have a job where it is expected that categorization works well for some partitions but not others; you do not pay the cost of bad categorization forever in the partitions where it works badly.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorizationDescriptor StopOnWarn(bool? value = true)
	{
		Instance.StopOnWarn = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorization Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorizationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorization(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorizationDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorization(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}