// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

/// <summary>
/// <para>
/// Pass through configuration options
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.PassThroughInferenceOptionsConverter))]
public sealed partial class PassThroughInferenceOptions
{
#if NET7_0_OR_GREATER
	public PassThroughInferenceOptions()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public PassThroughInferenceOptions()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PassThroughInferenceOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The field that is added to incoming documents to contain the inference prediction. Defaults to predicted_value.
	/// </para>
	/// </summary>
	public string? ResultsField { get; set; }

	/// <summary>
	/// <para>
	/// The tokenization options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig? Tokenization { get; set; }
	public Elastic.Clients.Elasticsearch.MachineLearning.Vocabulary? Vocabulary { get; set; }
}

/// <summary>
/// <para>
/// Pass through configuration options
/// </para>
/// </summary>
public readonly partial struct PassThroughInferenceOptionsDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.PassThroughInferenceOptions Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PassThroughInferenceOptionsDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.PassThroughInferenceOptions instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PassThroughInferenceOptionsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.PassThroughInferenceOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.PassThroughInferenceOptionsDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.PassThroughInferenceOptions instance) => new Elastic.Clients.Elasticsearch.MachineLearning.PassThroughInferenceOptionsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.PassThroughInferenceOptions(Elastic.Clients.Elasticsearch.MachineLearning.PassThroughInferenceOptionsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The field that is added to incoming documents to contain the inference prediction. Defaults to predicted_value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PassThroughInferenceOptionsDescriptor ResultsField(string? value)
	{
		Instance.ResultsField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The tokenization options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PassThroughInferenceOptionsDescriptor Tokenization(Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfig? value)
	{
		Instance.Tokenization = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The tokenization options
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PassThroughInferenceOptionsDescriptor Tokenization(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor> action)
	{
		Instance.Tokenization = Elastic.Clients.Elasticsearch.MachineLearning.TokenizationConfigDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PassThroughInferenceOptionsDescriptor Vocabulary(Elastic.Clients.Elasticsearch.MachineLearning.Vocabulary? value)
	{
		Instance.Vocabulary = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PassThroughInferenceOptionsDescriptor Vocabulary(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.VocabularyDescriptor> action)
	{
		Instance.Vocabulary = Elastic.Clients.Elasticsearch.MachineLearning.VocabularyDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.PassThroughInferenceOptions Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PassThroughInferenceOptionsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.MachineLearning.PassThroughInferenceOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PassThroughInferenceOptionsDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.PassThroughInferenceOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}