// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.ModelSnapshotConverter))]
public sealed partial class ModelSnapshot
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ModelSnapshot(string jobId, string minVersion, bool retain, long snapshotDocCount, string snapshotId, long timestamp)
	{
		JobId = jobId;
		MinVersion = minVersion;
		Retain = retain;
		SnapshotDocCount = snapshotDocCount;
		SnapshotId = snapshotId;
		Timestamp = timestamp;
	}
#if NET7_0_OR_GREATER
	public ModelSnapshot()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ModelSnapshot()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ModelSnapshot(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// An optional description of the job.
	/// </para>
	/// </summary>
	public string? Description { get; set; }

	/// <summary>
	/// <para>
	/// A numerical character string that uniquely identifies the job that the snapshot was created for.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string JobId { get; set; }

	/// <summary>
	/// <para>
	/// The timestamp of the latest processed record.
	/// </para>
	/// </summary>
	public int? LatestRecordTimeStamp { get; set; }

	/// <summary>
	/// <para>
	/// The timestamp of the latest bucket result.
	/// </para>
	/// </summary>
	public int? LatestResultTimeStamp { get; set; }

	/// <summary>
	/// <para>
	/// The minimum version required to be able to restore the model snapshot.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string MinVersion { get; set; }

	/// <summary>
	/// <para>
	/// Summary information describing the model.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ModelSizeStats? ModelSizeStats { get; set; }

	/// <summary>
	/// <para>
	/// If true, this snapshot will not be deleted during automatic cleanup of snapshots older than model_snapshot_retention_days. However, this snapshot will be deleted when the job is deleted. The default value is false.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool Retain { get; set; }

	/// <summary>
	/// <para>
	/// For internal use only.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long SnapshotDocCount { get; set; }

	/// <summary>
	/// <para>
	/// A numerical character string that uniquely identifies the model snapshot.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string SnapshotId { get; set; }

	/// <summary>
	/// <para>
	/// The creation timestamp for the snapshot.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Timestamp { get; set; }
}