// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class ModelSnapshotConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.ModelSnapshot>
{
	private static readonly System.Text.Json.JsonEncodedText PropDescription = System.Text.Json.JsonEncodedText.Encode("description");
	private static readonly System.Text.Json.JsonEncodedText PropJobId = System.Text.Json.JsonEncodedText.Encode("job_id");
	private static readonly System.Text.Json.JsonEncodedText PropLatestRecordTimeStamp = System.Text.Json.JsonEncodedText.Encode("latest_record_time_stamp");
	private static readonly System.Text.Json.JsonEncodedText PropLatestResultTimeStamp = System.Text.Json.JsonEncodedText.Encode("latest_result_time_stamp");
	private static readonly System.Text.Json.JsonEncodedText PropMinVersion = System.Text.Json.JsonEncodedText.Encode("min_version");
	private static readonly System.Text.Json.JsonEncodedText PropModelSizeStats = System.Text.Json.JsonEncodedText.Encode("model_size_stats");
	private static readonly System.Text.Json.JsonEncodedText PropRetain = System.Text.Json.JsonEncodedText.Encode("retain");
	private static readonly System.Text.Json.JsonEncodedText PropSnapshotDocCount = System.Text.Json.JsonEncodedText.Encode("snapshot_doc_count");
	private static readonly System.Text.Json.JsonEncodedText PropSnapshotId = System.Text.Json.JsonEncodedText.Encode("snapshot_id");
	private static readonly System.Text.Json.JsonEncodedText PropTimestamp = System.Text.Json.JsonEncodedText.Encode("timestamp");

	public override Elastic.Clients.Elasticsearch.MachineLearning.ModelSnapshot Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propDescription = default;
		LocalJsonValue<string> propJobId = default;
		LocalJsonValue<int?> propLatestRecordTimeStamp = default;
		LocalJsonValue<int?> propLatestResultTimeStamp = default;
		LocalJsonValue<string> propMinVersion = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.ModelSizeStats?> propModelSizeStats = default;
		LocalJsonValue<bool> propRetain = default;
		LocalJsonValue<long> propSnapshotDocCount = default;
		LocalJsonValue<string> propSnapshotId = default;
		LocalJsonValue<long> propTimestamp = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propDescription.TryReadProperty(ref reader, options, PropDescription, null))
			{
				continue;
			}

			if (propJobId.TryReadProperty(ref reader, options, PropJobId, null))
			{
				continue;
			}

			if (propLatestRecordTimeStamp.TryReadProperty(ref reader, options, PropLatestRecordTimeStamp, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propLatestResultTimeStamp.TryReadProperty(ref reader, options, PropLatestResultTimeStamp, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propMinVersion.TryReadProperty(ref reader, options, PropMinVersion, null))
			{
				continue;
			}

			if (propModelSizeStats.TryReadProperty(ref reader, options, PropModelSizeStats, null))
			{
				continue;
			}

			if (propRetain.TryReadProperty(ref reader, options, PropRetain, null))
			{
				continue;
			}

			if (propSnapshotDocCount.TryReadProperty(ref reader, options, PropSnapshotDocCount, null))
			{
				continue;
			}

			if (propSnapshotId.TryReadProperty(ref reader, options, PropSnapshotId, null))
			{
				continue;
			}

			if (propTimestamp.TryReadProperty(ref reader, options, PropTimestamp, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.ModelSnapshot(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Description = propDescription.Value,
			JobId = propJobId.Value,
			LatestRecordTimeStamp = propLatestRecordTimeStamp.Value,
			LatestResultTimeStamp = propLatestResultTimeStamp.Value,
			MinVersion = propMinVersion.Value,
			ModelSizeStats = propModelSizeStats.Value,
			Retain = propRetain.Value,
			SnapshotDocCount = propSnapshotDocCount.Value,
			SnapshotId = propSnapshotId.Value,
			Timestamp = propTimestamp.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.ModelSnapshot value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropDescription, value.Description, null, null);
		writer.WriteProperty(options, PropJobId, value.JobId, null, null);
		writer.WriteProperty(options, PropLatestRecordTimeStamp, value.LatestRecordTimeStamp, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropLatestResultTimeStamp, value.LatestResultTimeStamp, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropMinVersion, value.MinVersion, null, null);
		writer.WriteProperty(options, PropModelSizeStats, value.ModelSizeStats, null, null);
		writer.WriteProperty(options, PropRetain, value.Retain, null, null);
		writer.WriteProperty(options, PropSnapshotDocCount, value.SnapshotDocCount, null, null);
		writer.WriteProperty(options, PropSnapshotId, value.SnapshotId, null, null);
		writer.WriteProperty(options, PropTimestamp, value.Timestamp, null, null);
		writer.WriteEndObject();
	}
}