// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.ModelPlotConfigConverter))]
public sealed partial class ModelPlotConfig
{
#if NET7_0_OR_GREATER
	public ModelPlotConfig()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public ModelPlotConfig()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ModelPlotConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If true, enables calculation and storage of the model change annotations for each entity that is being analyzed.
	/// </para>
	/// </summary>
	public bool? AnnotationsEnabled { get; set; }

	/// <summary>
	/// <para>
	/// If true, enables calculation and storage of the model bounds for each entity that is being analyzed.
	/// </para>
	/// </summary>
	public bool? Enabled { get; set; }

	/// <summary>
	/// <para>
	/// Limits data collection to this comma separated list of partition or by field values. If terms are not specified or it is an empty string, no filtering is applied. Wildcards are not supported. Only the specified terms can be viewed when using the Single Metric Viewer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? Terms { get; set; }
}

public readonly partial struct ModelPlotConfigDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfig Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ModelPlotConfigDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfig instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ModelPlotConfigDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor<TDocument>(Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfig instance) => new Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfig(Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If true, enables calculation and storage of the model change annotations for each entity that is being analyzed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor<TDocument> AnnotationsEnabled(bool? value = true)
	{
		Instance.AnnotationsEnabled = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, enables calculation and storage of the model bounds for each entity that is being analyzed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor<TDocument> Enabled(bool? value = true)
	{
		Instance.Enabled = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limits data collection to this comma separated list of partition or by field values. If terms are not specified or it is an empty string, no filtering is applied. Wildcards are not supported. Only the specified terms can be viewed when using the Single Metric Viewer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor<TDocument> Terms(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Terms = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limits data collection to this comma separated list of partition or by field values. If terms are not specified or it is an empty string, no filtering is applied. Wildcards are not supported. Only the specified terms can be viewed when using the Single Metric Viewer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor<TDocument> Terms(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Terms = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfig Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct ModelPlotConfigDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfig Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ModelPlotConfigDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfig instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ModelPlotConfigDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfig instance) => new Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfig(Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If true, enables calculation and storage of the model change annotations for each entity that is being analyzed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor AnnotationsEnabled(bool? value = true)
	{
		Instance.AnnotationsEnabled = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, enables calculation and storage of the model bounds for each entity that is being analyzed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor Enabled(bool? value = true)
	{
		Instance.Enabled = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limits data collection to this comma separated list of partition or by field values. If terms are not specified or it is an empty string, no filtering is applied. Wildcards are not supported. Only the specified terms can be viewed when using the Single Metric Viewer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor Terms(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Terms = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limits data collection to this comma separated list of partition or by field values. If terms are not specified or it is an empty string, no filtering is applied. Wildcards are not supported. Only the specified terms can be viewed when using the Single Metric Viewer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor Terms<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Terms = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfig Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}