// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class MemoryStatusConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.MemoryStatus>
{
	private static readonly System.Text.Json.JsonEncodedText MemberHardLimit = System.Text.Json.JsonEncodedText.Encode("hard_limit");
	private static readonly System.Text.Json.JsonEncodedText MemberOk = System.Text.Json.JsonEncodedText.Encode("ok");
	private static readonly System.Text.Json.JsonEncodedText MemberSoftLimit = System.Text.Json.JsonEncodedText.Encode("soft_limit");

	public override Elastic.Clients.Elasticsearch.MachineLearning.MemoryStatus Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberHardLimit))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.MemoryStatus.HardLimit;
		}

		if (reader.ValueTextEquals(MemberOk))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.MemoryStatus.Ok;
		}

		if (reader.ValueTextEquals(MemberSoftLimit))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.MemoryStatus.SoftLimit;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberHardLimit.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.MemoryStatus.HardLimit;
		}

		if (string.Equals(value, MemberOk.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.MemoryStatus.Ok;
		}

		if (string.Equals(value, MemberSoftLimit.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.MemoryStatus.SoftLimit;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.MemoryStatus)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.MemoryStatus value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.MachineLearning.MemoryStatus.HardLimit:
				writer.WriteStringValue(MemberHardLimit);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.MemoryStatus.Ok:
				writer.WriteStringValue(MemberOk);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.MemoryStatus.SoftLimit:
				writer.WriteStringValue(MemberSoftLimit);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.MemoryStatus)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.MachineLearning.MemoryStatus ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.MemoryStatus value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}