// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.MemStatsConverter))]
public sealed partial class MemStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MemStats(int adjustedTotalInBytes, Elastic.Clients.Elasticsearch.MachineLearning.MemMlStats ml, int totalInBytes)
	{
		AdjustedTotalInBytes = adjustedTotalInBytes;
		Ml = ml;
		TotalInBytes = totalInBytes;
	}
#if NET7_0_OR_GREATER
	public MemStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public MemStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal MemStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If the amount of physical memory has been overridden using the es.total_memory_bytes system property
	/// then this reports the overridden value. Otherwise it reports the same value as total.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? AdjustedTotal { get; set; }

	/// <summary>
	/// <para>
	/// If the amount of physical memory has been overridden using the <c>es.total_memory_bytes</c> system property
	/// then this reports the overridden value in bytes. Otherwise it reports the same value as <c>total_in_bytes</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int AdjustedTotalInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about machine learning use of native memory on the node.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.MemMlStats Ml { get; set; }

	/// <summary>
	/// <para>
	/// Total amount of physical memory.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? Total { get; set; }

	/// <summary>
	/// <para>
	/// Total amount of physical memory in bytes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int TotalInBytes { get; set; }
}