// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.MemMlStatsConverter))]
public sealed partial class MemMlStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MemMlStats(int anomalyDetectorsInBytes, int dataFrameAnalyticsInBytes, int maxInBytes, int nativeCodeOverheadInBytes, int nativeInferenceInBytes)
	{
		AnomalyDetectorsInBytes = anomalyDetectorsInBytes;
		DataFrameAnalyticsInBytes = dataFrameAnalyticsInBytes;
		MaxInBytes = maxInBytes;
		NativeCodeOverheadInBytes = nativeCodeOverheadInBytes;
		NativeInferenceInBytes = nativeInferenceInBytes;
	}
#if NET7_0_OR_GREATER
	public MemMlStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public MemMlStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal MemMlStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Amount of native memory set aside for anomaly detection jobs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? AnomalyDetectors { get; set; }

	/// <summary>
	/// <para>
	/// Amount of native memory, in bytes, set aside for anomaly detection jobs.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int AnomalyDetectorsInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Amount of native memory set aside for data frame analytics jobs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? DataFrameAnalytics { get; set; }

	/// <summary>
	/// <para>
	/// Amount of native memory, in bytes, set aside for data frame analytics jobs.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int DataFrameAnalyticsInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Maximum amount of native memory (separate to the JVM heap) that may be used by machine learning native processes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? Max { get; set; }

	/// <summary>
	/// <para>
	/// Maximum amount of native memory (separate to the JVM heap), in bytes, that may be used by machine learning native processes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int MaxInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Amount of native memory set aside for loading machine learning native code shared libraries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? NativeCodeOverhead { get; set; }

	/// <summary>
	/// <para>
	/// Amount of native memory, in bytes, set aside for loading machine learning native code shared libraries.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int NativeCodeOverheadInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Amount of native memory set aside for trained models that have a PyTorch model_type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? NativeInference { get; set; }

	/// <summary>
	/// <para>
	/// Amount of native memory, in bytes, set aside for trained models that have a PyTorch model_type.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int NativeInferenceInBytes { get; set; }
}