// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class MemMlStatsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.MemMlStats>
{
	private static readonly System.Text.Json.JsonEncodedText PropAnomalyDetectors = System.Text.Json.JsonEncodedText.Encode("anomaly_detectors");
	private static readonly System.Text.Json.JsonEncodedText PropAnomalyDetectorsInBytes = System.Text.Json.JsonEncodedText.Encode("anomaly_detectors_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropDataFrameAnalytics = System.Text.Json.JsonEncodedText.Encode("data_frame_analytics");
	private static readonly System.Text.Json.JsonEncodedText PropDataFrameAnalyticsInBytes = System.Text.Json.JsonEncodedText.Encode("data_frame_analytics_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropMax = System.Text.Json.JsonEncodedText.Encode("max");
	private static readonly System.Text.Json.JsonEncodedText PropMaxInBytes = System.Text.Json.JsonEncodedText.Encode("max_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropNativeCodeOverhead = System.Text.Json.JsonEncodedText.Encode("native_code_overhead");
	private static readonly System.Text.Json.JsonEncodedText PropNativeCodeOverheadInBytes = System.Text.Json.JsonEncodedText.Encode("native_code_overhead_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropNativeInference = System.Text.Json.JsonEncodedText.Encode("native_inference");
	private static readonly System.Text.Json.JsonEncodedText PropNativeInferenceInBytes = System.Text.Json.JsonEncodedText.Encode("native_inference_in_bytes");

	public override Elastic.Clients.Elasticsearch.MachineLearning.MemMlStats Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propAnomalyDetectors = default;
		LocalJsonValue<int> propAnomalyDetectorsInBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propDataFrameAnalytics = default;
		LocalJsonValue<int> propDataFrameAnalyticsInBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propMax = default;
		LocalJsonValue<int> propMaxInBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propNativeCodeOverhead = default;
		LocalJsonValue<int> propNativeCodeOverheadInBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propNativeInference = default;
		LocalJsonValue<int> propNativeInferenceInBytes = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAnomalyDetectors.TryReadProperty(ref reader, options, PropAnomalyDetectors, null))
			{
				continue;
			}

			if (propAnomalyDetectorsInBytes.TryReadProperty(ref reader, options, PropAnomalyDetectorsInBytes, null))
			{
				continue;
			}

			if (propDataFrameAnalytics.TryReadProperty(ref reader, options, PropDataFrameAnalytics, null))
			{
				continue;
			}

			if (propDataFrameAnalyticsInBytes.TryReadProperty(ref reader, options, PropDataFrameAnalyticsInBytes, null))
			{
				continue;
			}

			if (propMax.TryReadProperty(ref reader, options, PropMax, null))
			{
				continue;
			}

			if (propMaxInBytes.TryReadProperty(ref reader, options, PropMaxInBytes, null))
			{
				continue;
			}

			if (propNativeCodeOverhead.TryReadProperty(ref reader, options, PropNativeCodeOverhead, null))
			{
				continue;
			}

			if (propNativeCodeOverheadInBytes.TryReadProperty(ref reader, options, PropNativeCodeOverheadInBytes, null))
			{
				continue;
			}

			if (propNativeInference.TryReadProperty(ref reader, options, PropNativeInference, null))
			{
				continue;
			}

			if (propNativeInferenceInBytes.TryReadProperty(ref reader, options, PropNativeInferenceInBytes, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.MemMlStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			AnomalyDetectors = propAnomalyDetectors.Value,
			AnomalyDetectorsInBytes = propAnomalyDetectorsInBytes.Value,
			DataFrameAnalytics = propDataFrameAnalytics.Value,
			DataFrameAnalyticsInBytes = propDataFrameAnalyticsInBytes.Value,
			Max = propMax.Value,
			MaxInBytes = propMaxInBytes.Value,
			NativeCodeOverhead = propNativeCodeOverhead.Value,
			NativeCodeOverheadInBytes = propNativeCodeOverheadInBytes.Value,
			NativeInference = propNativeInference.Value,
			NativeInferenceInBytes = propNativeInferenceInBytes.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.MemMlStats value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAnomalyDetectors, value.AnomalyDetectors, null, null);
		writer.WriteProperty(options, PropAnomalyDetectorsInBytes, value.AnomalyDetectorsInBytes, null, null);
		writer.WriteProperty(options, PropDataFrameAnalytics, value.DataFrameAnalytics, null, null);
		writer.WriteProperty(options, PropDataFrameAnalyticsInBytes, value.DataFrameAnalyticsInBytes, null, null);
		writer.WriteProperty(options, PropMax, value.Max, null, null);
		writer.WriteProperty(options, PropMaxInBytes, value.MaxInBytes, null, null);
		writer.WriteProperty(options, PropNativeCodeOverhead, value.NativeCodeOverhead, null, null);
		writer.WriteProperty(options, PropNativeCodeOverheadInBytes, value.NativeCodeOverheadInBytes, null, null);
		writer.WriteProperty(options, PropNativeInference, value.NativeInference, null, null);
		writer.WriteProperty(options, PropNativeInferenceInBytes, value.NativeInferenceInBytes, null, null);
		writer.WriteEndObject();
	}
}