// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class LimitsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.Limits>
{
	private static readonly System.Text.Json.JsonEncodedText PropEffectiveMaxModelMemoryLimit = System.Text.Json.JsonEncodedText.Encode("effective_max_model_memory_limit");
	private static readonly System.Text.Json.JsonEncodedText PropMaxModelMemoryLimit = System.Text.Json.JsonEncodedText.Encode("max_model_memory_limit");
	private static readonly System.Text.Json.JsonEncodedText PropMaxSingleMlNodeProcessors = System.Text.Json.JsonEncodedText.Encode("max_single_ml_node_processors");
	private static readonly System.Text.Json.JsonEncodedText PropTotalMlMemory = System.Text.Json.JsonEncodedText.Encode("total_ml_memory");
	private static readonly System.Text.Json.JsonEncodedText PropTotalMlProcessors = System.Text.Json.JsonEncodedText.Encode("total_ml_processors");

	public override Elastic.Clients.Elasticsearch.MachineLearning.Limits Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propEffectiveMaxModelMemoryLimit = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propMaxModelMemoryLimit = default;
		LocalJsonValue<int?> propMaxSingleMlNodeProcessors = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize> propTotalMlMemory = default;
		LocalJsonValue<int?> propTotalMlProcessors = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propEffectiveMaxModelMemoryLimit.TryReadProperty(ref reader, options, PropEffectiveMaxModelMemoryLimit, null))
			{
				continue;
			}

			if (propMaxModelMemoryLimit.TryReadProperty(ref reader, options, PropMaxModelMemoryLimit, null))
			{
				continue;
			}

			if (propMaxSingleMlNodeProcessors.TryReadProperty(ref reader, options, PropMaxSingleMlNodeProcessors, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propTotalMlMemory.TryReadProperty(ref reader, options, PropTotalMlMemory, null))
			{
				continue;
			}

			if (propTotalMlProcessors.TryReadProperty(ref reader, options, PropTotalMlProcessors, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.Limits(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			EffectiveMaxModelMemoryLimit = propEffectiveMaxModelMemoryLimit.Value,
			MaxModelMemoryLimit = propMaxModelMemoryLimit.Value,
			MaxSingleMlNodeProcessors = propMaxSingleMlNodeProcessors.Value,
			TotalMlMemory = propTotalMlMemory.Value,
			TotalMlProcessors = propTotalMlProcessors.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.Limits value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropEffectiveMaxModelMemoryLimit, value.EffectiveMaxModelMemoryLimit, null, null);
		writer.WriteProperty(options, PropMaxModelMemoryLimit, value.MaxModelMemoryLimit, null, null);
		writer.WriteProperty(options, PropMaxSingleMlNodeProcessors, value.MaxSingleMlNodeProcessors, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropTotalMlMemory, value.TotalMlMemory, null, null);
		writer.WriteProperty(options, PropTotalMlProcessors, value.TotalMlProcessors, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteEndObject();
	}
}