// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.LearningToRankConfigConverter))]
public sealed partial class LearningToRankConfig
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public LearningToRankConfig(int numTopFeatureImportanceValues)
	{
		NumTopFeatureImportanceValues = numTopFeatureImportanceValues;
	}
#if NET7_0_OR_GREATER
	public LearningToRankConfig()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public LearningToRankConfig()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal LearningToRankConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public System.Collections.Generic.IDictionary<string, object>? DefaultParams { get; set; }
	public System.Collections.Generic.ICollection<System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractor>>? FeatureExtractors { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	int NumTopFeatureImportanceValues { get; set; }
}

public readonly partial struct LearningToRankConfigDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfig Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public LearningToRankConfigDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfig instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public LearningToRankConfigDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor<TDocument>(Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfig instance) => new Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfig(Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor<TDocument> DefaultParams(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.DefaultParams = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor<TDocument> DefaultParams()
	{
		Instance.DefaultParams = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor<TDocument> DefaultParams(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.DefaultParams = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor<TDocument> AddDefaultParam(string key, object value)
	{
		Instance.DefaultParams ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.DefaultParams.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor<TDocument> FeatureExtractors(System.Collections.Generic.ICollection<System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractor>>? value)
	{
		Instance.FeatureExtractors = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor<TDocument> FeatureExtractors(params System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractor>[] values)
	{
		Instance.FeatureExtractors = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor<TDocument> FeatureExtractors(params System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringQueryFeatureExtractor<TDocument>>?[] actions)
	{
		var items = new System.Collections.Generic.List<System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractor>>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringQueryFeatureExtractor<TDocument>.Build(action));
		}

		Instance.FeatureExtractors = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor<TDocument> NumTopFeatureImportanceValues(int value)
	{
		Instance.NumTopFeatureImportanceValues = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfig Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct LearningToRankConfigDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfig Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public LearningToRankConfigDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfig instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public LearningToRankConfigDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfig instance) => new Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfig(Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor DefaultParams(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.DefaultParams = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor DefaultParams()
	{
		Instance.DefaultParams = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor DefaultParams(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.DefaultParams = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor AddDefaultParam(string key, object value)
	{
		Instance.DefaultParams ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.DefaultParams.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor FeatureExtractors(System.Collections.Generic.ICollection<System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractor>>? value)
	{
		Instance.FeatureExtractors = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor FeatureExtractors(params System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractor>[] values)
	{
		Instance.FeatureExtractors = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor FeatureExtractors(params System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringQueryFeatureExtractor>?[] actions)
	{
		var items = new System.Collections.Generic.List<System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractor>>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringQueryFeatureExtractor.Build(action));
		}

		Instance.FeatureExtractors = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor FeatureExtractors<T>(params System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringQueryFeatureExtractor<T>>?[] actions)
	{
		var items = new System.Collections.Generic.List<System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.MachineLearning.QueryFeatureExtractor>>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringQueryFeatureExtractor<T>.Build(action));
		}

		Instance.FeatureExtractors = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor NumTopFeatureImportanceValues(int value)
	{
		Instance.NumTopFeatureImportanceValues = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfig Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfigDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}