// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.JvmStatsConverter))]
public sealed partial class JvmStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public JvmStats(int heapMaxInBytes, int javaInferenceInBytes, int javaInferenceMaxInBytes)
	{
		HeapMaxInBytes = heapMaxInBytes;
		JavaInferenceInBytes = javaInferenceInBytes;
		JavaInferenceMaxInBytes = javaInferenceMaxInBytes;
	}
#if NET7_0_OR_GREATER
	public JvmStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public JvmStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal JvmStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Maximum amount of memory available for use by the heap.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? HeapMax { get; set; }

	/// <summary>
	/// <para>
	/// Maximum amount of memory, in bytes, available for use by the heap.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int HeapMaxInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Amount of Java heap currently being used for caching inference models.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? JavaInference { get; set; }

	/// <summary>
	/// <para>
	/// Amount of Java heap, in bytes, currently being used for caching inference models.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int JavaInferenceInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Maximum amount of Java heap to be used for caching inference models.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? JavaInferenceMax { get; set; }

	/// <summary>
	/// <para>
	/// Maximum amount of Java heap, in bytes, to be used for caching inference models.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int JavaInferenceMaxInBytes { get; set; }
}