// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.JobTimingStatsConverter))]
public sealed partial class JobTimingStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public JobTimingStats(long bucketCount, System.TimeSpan exponentialAverageBucketProcessingTimePerHourMs, string jobId, System.TimeSpan totalBucketProcessingTimeMs)
	{
		BucketCount = bucketCount;
		ExponentialAverageBucketProcessingTimePerHourMs = exponentialAverageBucketProcessingTimePerHourMs;
		JobId = jobId;
		TotalBucketProcessingTimeMs = totalBucketProcessingTimeMs;
	}
#if NET7_0_OR_GREATER
	public JobTimingStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public JobTimingStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal JobTimingStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public System.TimeSpan? AverageBucketProcessingTimeMs { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long BucketCount { get; set; }
	public System.TimeSpan? ExponentialAverageBucketProcessingTimeMs { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan ExponentialAverageBucketProcessingTimePerHourMs { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string JobId { get; set; }
	public System.TimeSpan? MaximumBucketProcessingTimeMs { get; set; }
	public System.TimeSpan? MinimumBucketProcessingTimeMs { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan TotalBucketProcessingTimeMs { get; set; }
}