// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.JobStatsConverter))]
public sealed partial class JobStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public JobStats(Elastic.Clients.Elasticsearch.MachineLearning.DataCounts dataCounts, Elastic.Clients.Elasticsearch.MachineLearning.JobForecastStatistics forecastsStats, string jobId, Elastic.Clients.Elasticsearch.MachineLearning.ModelSizeStats modelSizeStats, Elastic.Clients.Elasticsearch.MachineLearning.JobState state, Elastic.Clients.Elasticsearch.MachineLearning.JobTimingStats timingStats)
	{
		DataCounts = dataCounts;
		ForecastsStats = forecastsStats;
		JobId = jobId;
		ModelSizeStats = modelSizeStats;
		State = state;
		TimingStats = timingStats;
	}
#if NET7_0_OR_GREATER
	public JobStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public JobStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal JobStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// For open anomaly detection jobs only, contains messages relating to the selection of a node to run the job.
	/// </para>
	/// </summary>
	public string? AssignmentExplanation { get; set; }

	/// <summary>
	/// <para>
	/// An object that describes the quantity of input to the job and any related error counts.
	/// The <c>data_count</c> values are cumulative for the lifetime of a job.
	/// If a model snapshot is reverted or old results are deleted, the job counts are not reset.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.DataCounts DataCounts { get; set; }

	/// <summary>
	/// <para>
	/// Indicates that the process of deleting the job is in progress but not yet completed. It is only reported when <c>true</c>.
	/// </para>
	/// </summary>
	public bool? Deleting { get; set; }

	/// <summary>
	/// <para>
	/// An object that provides statistical information about forecasts belonging to this job.
	/// Some statistics are omitted if no forecasts have been made.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.JobForecastStatistics ForecastsStats { get; set; }

	/// <summary>
	/// <para>
	/// Identifier for the anomaly detection job.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string JobId { get; set; }

	/// <summary>
	/// <para>
	/// An object that provides information about the size and contents of the model.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.ModelSizeStats ModelSizeStats { get; set; }

	/// <summary>
	/// <para>
	/// Contains properties for the node that runs the job.
	/// This information is available only for open jobs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DiscoveryNodeCompact? Node { get; set; }

	/// <summary>
	/// <para>
	/// For open jobs only, the elapsed time for which the job has been open.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? OpenTime { get; set; }

	/// <summary>
	/// <para>
	/// The status of the anomaly detection job, which can be one of the following values: <c>closed</c>, <c>closing</c>, <c>failed</c>, <c>opened</c>, <c>opening</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.JobState State { get; set; }

	/// <summary>
	/// <para>
	/// An object that provides statistical information about timing aspect of this job.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.JobTimingStats TimingStats { get; set; }
}