// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class JobStateConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.JobState>
{
	private static readonly System.Text.Json.JsonEncodedText MemberClosed = System.Text.Json.JsonEncodedText.Encode("closed");
	private static readonly System.Text.Json.JsonEncodedText MemberClosing = System.Text.Json.JsonEncodedText.Encode("closing");
	private static readonly System.Text.Json.JsonEncodedText MemberFailed = System.Text.Json.JsonEncodedText.Encode("failed");
	private static readonly System.Text.Json.JsonEncodedText MemberOpened = System.Text.Json.JsonEncodedText.Encode("opened");
	private static readonly System.Text.Json.JsonEncodedText MemberOpening = System.Text.Json.JsonEncodedText.Encode("opening");

	public override Elastic.Clients.Elasticsearch.MachineLearning.JobState Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberClosed))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.JobState.Closed;
		}

		if (reader.ValueTextEquals(MemberClosing))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.JobState.Closing;
		}

		if (reader.ValueTextEquals(MemberFailed))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.JobState.Failed;
		}

		if (reader.ValueTextEquals(MemberOpened))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.JobState.Opened;
		}

		if (reader.ValueTextEquals(MemberOpening))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.JobState.Opening;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberClosed.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.JobState.Closed;
		}

		if (string.Equals(value, MemberClosing.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.JobState.Closing;
		}

		if (string.Equals(value, MemberFailed.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.JobState.Failed;
		}

		if (string.Equals(value, MemberOpened.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.JobState.Opened;
		}

		if (string.Equals(value, MemberOpening.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.JobState.Opening;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.JobState)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.JobState value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.MachineLearning.JobState.Closed:
				writer.WriteStringValue(MemberClosed);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.JobState.Closing:
				writer.WriteStringValue(MemberClosing);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.JobState.Failed:
				writer.WriteStringValue(MemberFailed);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.JobState.Opened:
				writer.WriteStringValue(MemberOpened);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.JobState.Opening:
				writer.WriteStringValue(MemberOpening);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.JobState)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.MachineLearning.JobState ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.JobState value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}