// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class JobBlockedReasonConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.JobBlockedReason>
{
	private static readonly System.Text.Json.JsonEncodedText MemberDelete = System.Text.Json.JsonEncodedText.Encode("delete");
	private static readonly System.Text.Json.JsonEncodedText MemberReset = System.Text.Json.JsonEncodedText.Encode("reset");
	private static readonly System.Text.Json.JsonEncodedText MemberRevert = System.Text.Json.JsonEncodedText.Encode("revert");

	public override Elastic.Clients.Elasticsearch.MachineLearning.JobBlockedReason Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberDelete))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.JobBlockedReason.Delete;
		}

		if (reader.ValueTextEquals(MemberReset))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.JobBlockedReason.Reset;
		}

		if (reader.ValueTextEquals(MemberRevert))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.JobBlockedReason.Revert;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberDelete.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.JobBlockedReason.Delete;
		}

		if (string.Equals(value, MemberReset.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.JobBlockedReason.Reset;
		}

		if (string.Equals(value, MemberRevert.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.JobBlockedReason.Revert;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.JobBlockedReason)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.JobBlockedReason value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.MachineLearning.JobBlockedReason.Delete:
				writer.WriteStringValue(MemberDelete);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.JobBlockedReason.Reset:
				writer.WriteStringValue(MemberReset);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.JobBlockedReason.Revert:
				writer.WriteStringValue(MemberRevert);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.JobBlockedReason)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.MachineLearning.JobBlockedReason ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.JobBlockedReason value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}