// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.JobConverter))]
public sealed partial class Job
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public Job(bool allowLazyOpen, Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfig analysisConfig, Elastic.Clients.Elasticsearch.MachineLearning.DataDescription dataDescription, string jobId, long modelSnapshotRetentionDays, string resultsIndexName)
	{
		AllowLazyOpen = allowLazyOpen;
		AnalysisConfig = analysisConfig;
		DataDescription = dataDescription;
		JobId = jobId;
		ModelSnapshotRetentionDays = modelSnapshotRetentionDays;
		ResultsIndexName = resultsIndexName;
	}
#if NET7_0_OR_GREATER
	public Job()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public Job()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Job(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option.
	/// Specifies whether this job can open when there is insufficient machine learning node capacity for it to be immediately assigned to a node.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool AllowLazyOpen { get; set; }

	/// <summary>
	/// <para>
	/// The analysis configuration, which specifies how to analyze the data.
	/// After you create a job, you cannot change the analysis configuration; all the properties are informational.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfig AnalysisConfig { get; set; }

	/// <summary>
	/// <para>
	/// Limits can be applied for the resources required to hold the mathematical models in memory.
	/// These limits are approximate and can be set per job.
	/// They do not control the memory used by other processes, for example the Elasticsearch Java processes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisLimits? AnalysisLimits { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option.
	/// The time between each periodic persistence of the model.
	/// The default value is a randomized value between 3 to 4 hours, which avoids all jobs persisting at exactly the same time.
	/// The smallest allowed value is 1 hour.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? BackgroundPersistInterval { get; set; }
	public Elastic.Clients.Elasticsearch.MachineLearning.JobBlocked? Blocked { get; set; }
	public System.DateTimeOffset? CreateTime { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option.
	/// Contains custom metadata about the job.
	/// </para>
	/// </summary>
	public object? CustomSettings { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option, which affects the automatic removal of old model snapshots for this job.
	/// It specifies a period of time (in days) after which only the first snapshot per day is retained.
	/// This period is relative to the timestamp of the most recent snapshot for this job.
	/// Valid values range from 0 to <c>model_snapshot_retention_days</c>.
	/// </para>
	/// </summary>
	public long? DailyModelSnapshotRetentionAfterDays { get; set; }

	/// <summary>
	/// <para>
	/// The data description defines the format of the input data when you send data to the job by using the post data API.
	/// Note that when configuring a datafeed, these properties are automatically set.
	/// When data is received via the post data API, it is not stored in Elasticsearch.
	/// Only the results for anomaly detection are retained.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.DataDescription DataDescription { get; set; }

	/// <summary>
	/// <para>
	/// The datafeed, which retrieves data from Elasticsearch for analysis by the job.
	/// You can associate only one datafeed with each anomaly detection job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.Datafeed? DatafeedConfig { get; set; }

	/// <summary>
	/// <para>
	/// Indicates that the process of deleting the job is in progress but not yet completed.
	/// It is only reported when <c>true</c>.
	/// </para>
	/// </summary>
	public bool? Deleting { get; set; }

	/// <summary>
	/// <para>
	/// A description of the job.
	/// </para>
	/// </summary>
	public string? Description { get; set; }

	/// <summary>
	/// <para>
	/// If the job closed or failed, this is the time the job finished, otherwise it is <c>null</c>.
	/// This property is informational; you cannot change its value.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? FinishedTime { get; set; }

	/// <summary>
	/// <para>
	/// A list of job groups.
	/// A job can belong to no groups or many.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyCollection<string>? Groups { get; set; }

	/// <summary>
	/// <para>
	/// Identifier for the anomaly detection job.
	/// This identifier can contain lowercase alphanumeric characters (a-z and 0-9), hyphens, and underscores.
	/// It must start and end with alphanumeric characters.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string JobId { get; set; }

	/// <summary>
	/// <para>
	/// Reserved for future use, currently set to <c>anomaly_detector</c>.
	/// </para>
	/// </summary>
	public string? JobType { get; set; }

	/// <summary>
	/// <para>
	/// The machine learning configuration version number at which the the job was created.
	/// </para>
	/// </summary>
	public string? JobVersion { get; set; }

	/// <summary>
	/// <para>
	/// This advanced configuration option stores model information along with the results.
	/// It provides a more detailed view into anomaly detection.
	/// Model plot provides a simplified and indicative view of the model and its bounds.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfig? ModelPlotConfig { get; set; }
	public string? ModelSnapshotId { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option, which affects the automatic removal of old model snapshots for this job.
	/// It specifies the maximum period of time (in days) that snapshots are retained.
	/// This period is relative to the timestamp of the most recent snapshot for this job.
	/// By default, snapshots ten days older than the newest snapshot are deleted.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long ModelSnapshotRetentionDays { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option.
	/// The period over which adjustments to the score are applied, as new data is seen.
	/// The default value is the longer of 30 days or 100 <c>bucket_spans</c>.
	/// </para>
	/// </summary>
	public long? RenormalizationWindowDays { get; set; }

	/// <summary>
	/// <para>
	/// A text string that affects the name of the machine learning results index.
	/// The default value is <c>shared</c>, which generates an index named <c>.ml-anomalies-shared</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ResultsIndexName { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option.
	/// The period of time (in days) that results are retained.
	/// Age is calculated relative to the timestamp of the latest bucket result.
	/// If this property has a non-null value, once per day at 00:30 (server time), results that are the specified number of days older than the latest bucket result are deleted from Elasticsearch.
	/// The default value is null, which means all results are retained.
	/// Annotations generated by the system also count as results for retention purposes; they are deleted after the same number of days as results.
	/// Annotations added by users are retained forever.
	/// </para>
	/// </summary>
	public long? ResultsRetentionDays { get; set; }
}