// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.InfluencerConverter))]
public sealed partial class Influencer
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public Influencer(System.TimeSpan bucketSpan, string influencerFieldName, string influencerFieldValue, double influencerScore, double initialInfluencerScore, bool isInterim, string jobId, double probability, string resultType, System.DateTimeOffset timestamp)
	{
		BucketSpan = bucketSpan;
		InfluencerFieldName = influencerFieldName;
		InfluencerFieldValue = influencerFieldValue;
		InfluencerScore = influencerScore;
		InitialInfluencerScore = initialInfluencerScore;
		IsInterim = isInterim;
		JobId = jobId;
		Probability = probability;
		ResultType = resultType;
		Timestamp = timestamp;
	}
#if NET7_0_OR_GREATER
	public Influencer()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public Influencer()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Influencer(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The length of the bucket in seconds. This value matches the bucket span that is specified in the job.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan BucketSpan { get; set; }

	/// <summary>
	/// <para>
	/// Additional influencer properties are added, depending on the fields being analyzed. For example, if it’s
	/// analyzing <c>user_name</c> as an influencer, a field <c>user_name</c> is added to the result document. This
	/// information enables you to filter the anomaly results more easily.
	/// </para>
	/// </summary>
	public string? Foo { get; set; }

	/// <summary>
	/// <para>
	/// The field name of the influencer.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string InfluencerFieldName { get; set; }

	/// <summary>
	/// <para>
	/// The entity that influenced, contributed to, or was to blame for the anomaly.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string InfluencerFieldValue { get; set; }

	/// <summary>
	/// <para>
	/// A normalized score between 0-100, which is based on the probability of the influencer in this bucket aggregated
	/// across detectors. Unlike <c>initial_influencer_score</c>, this value is updated by a re-normalization process as new
	/// data is analyzed.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	double InfluencerScore { get; set; }

	/// <summary>
	/// <para>
	/// A normalized score between 0-100, which is based on the probability of the influencer aggregated across detectors.
	/// This is the initial value that was calculated at the time the bucket was processed.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	double InitialInfluencerScore { get; set; }

	/// <summary>
	/// <para>
	/// If true, this is an interim result. In other words, the results are calculated based on partial input data.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool IsInterim { get; set; }

	/// <summary>
	/// <para>
	/// Identifier for the anomaly detection job.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string JobId { get; set; }

	/// <summary>
	/// <para>
	/// The probability that the influencer has this behavior, in the range 0 to 1. This value can be held to a high
	/// precision of over 300 decimal places, so the <c>influencer_score</c> is provided as a human-readable and friendly
	/// interpretation of this value.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	double Probability { get; set; }

	/// <summary>
	/// <para>
	/// Internal. This value is always set to <c>influencer</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ResultType { get; set; }

	/// <summary>
	/// <para>
	/// The start time of the bucket for which these results were calculated.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.DateTimeOffset Timestamp { get; set; }
}