// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.InferenceResponseResultConverter))]
public sealed partial class InferenceResponseResult
{
#if NET7_0_OR_GREATER
	public InferenceResponseResult()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public InferenceResponseResult()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal InferenceResponseResult(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If the model is trained for named entity recognition (NER) tasks, the response contains the recognized entities.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelEntities>? Entities { get; set; }

	/// <summary>
	/// <para>
	/// The feature importance for the inference results. Relevant only for classification or regression models
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelInferenceFeatureImportance>? FeatureImportance { get; set; }

	/// <summary>
	/// <para>
	/// Indicates whether the input text was truncated to meet the model's maximum sequence length limit. This property
	/// is present only when it is true.
	/// </para>
	/// </summary>
	public bool? IsTruncated { get; set; }

	/// <summary>
	/// <para>
	/// If the model is trained for a text classification or zero shot classification task, the response is the
	/// predicted class.
	/// For named entity recognition (NER) tasks, it contains the annotated text output.
	/// For fill mask tasks, it contains the top prediction for replacing the mask token.
	/// For text embedding tasks, it contains the raw numerical text embedding values.
	/// For regression models, its a numerical value
	/// For classification models, it may be an integer, double, boolean or string depending on prediction type
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>>? PredictedValue { get; set; }

	/// <summary>
	/// <para>
	/// For fill mask tasks, the response contains the input text sequence with the mask token replaced by the predicted
	/// value.
	/// Additionally
	/// </para>
	/// </summary>
	public string? PredictedValueSequence { get; set; }

	/// <summary>
	/// <para>
	/// Specifies a probability for the predicted value.
	/// </para>
	/// </summary>
	public double? PredictionProbability { get; set; }

	/// <summary>
	/// <para>
	/// Specifies a confidence score for the predicted value.
	/// </para>
	/// </summary>
	public double? PredictionScore { get; set; }

	/// <summary>
	/// <para>
	/// For fill mask, text classification, and zero shot classification tasks, the response contains a list of top
	/// class entries.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.MachineLearning.TopClassEntry>? TopClasses { get; set; }

	/// <summary>
	/// <para>
	/// If the request failed, the response contains the reason for the failure.
	/// </para>
	/// </summary>
	public string? Warning { get; set; }
}