// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class InferenceConfigCreateConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.InferenceConfigCreate>
{
	private static readonly System.Text.Json.JsonEncodedText VariantClassification = System.Text.Json.JsonEncodedText.Encode("classification");
	private static readonly System.Text.Json.JsonEncodedText VariantFillMask = System.Text.Json.JsonEncodedText.Encode("fill_mask");
	private static readonly System.Text.Json.JsonEncodedText VariantLearningToRank = System.Text.Json.JsonEncodedText.Encode("learning_to_rank");
	private static readonly System.Text.Json.JsonEncodedText VariantNer = System.Text.Json.JsonEncodedText.Encode("ner");
	private static readonly System.Text.Json.JsonEncodedText VariantPassThrough = System.Text.Json.JsonEncodedText.Encode("pass_through");
	private static readonly System.Text.Json.JsonEncodedText VariantQuestionAnswering = System.Text.Json.JsonEncodedText.Encode("question_answering");
	private static readonly System.Text.Json.JsonEncodedText VariantRegression = System.Text.Json.JsonEncodedText.Encode("regression");
	private static readonly System.Text.Json.JsonEncodedText VariantTextClassification = System.Text.Json.JsonEncodedText.Encode("text_classification");
	private static readonly System.Text.Json.JsonEncodedText VariantTextEmbedding = System.Text.Json.JsonEncodedText.Encode("text_embedding");
	private static readonly System.Text.Json.JsonEncodedText VariantTextExpansion = System.Text.Json.JsonEncodedText.Encode("text_expansion");
	private static readonly System.Text.Json.JsonEncodedText VariantZeroShotClassification = System.Text.Json.JsonEncodedText.Encode("zero_shot_classification");

	public override Elastic.Clients.Elasticsearch.MachineLearning.InferenceConfigCreate Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		string? variantType = null;
		object? variant = null;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (reader.ValueTextEquals(VariantClassification))
			{
				variantType = VariantClassification.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptions>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantFillMask))
			{
				variantType = VariantFillMask.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.MachineLearning.FillMaskInferenceOptions>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantLearningToRank))
			{
				variantType = VariantLearningToRank.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfig>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantNer))
			{
				variantType = VariantNer.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.MachineLearning.NerInferenceOptions>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantPassThrough))
			{
				variantType = VariantPassThrough.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.MachineLearning.PassThroughInferenceOptions>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantQuestionAnswering))
			{
				variantType = VariantQuestionAnswering.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.MachineLearning.QuestionAnsweringInferenceOptions>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantRegression))
			{
				variantType = VariantRegression.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.MachineLearning.RegressionInferenceOptions>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantTextClassification))
			{
				variantType = VariantTextClassification.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.MachineLearning.TextClassificationInferenceOptions>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantTextEmbedding))
			{
				variantType = VariantTextEmbedding.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.MachineLearning.TextEmbeddingInferenceOptions>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantTextExpansion))
			{
				variantType = VariantTextExpansion.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.MachineLearning.TextExpansionInferenceOptions>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantZeroShotClassification))
			{
				variantType = VariantZeroShotClassification.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.MachineLearning.ZeroShotClassificationInferenceOptions>(options, null);
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.InferenceConfigCreate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			VariantType = variantType,
			Variant = variant
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.InferenceConfigCreate value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		switch (value.VariantType)
		{
			case null:
				break;
			case "classification":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.MachineLearning.ClassificationInferenceOptions)value.Variant, null, null);
				break;
			case "fill_mask":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.MachineLearning.FillMaskInferenceOptions)value.Variant, null, null);
				break;
			case "learning_to_rank":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.MachineLearning.LearningToRankConfig)value.Variant, null, null);
				break;
			case "ner":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.MachineLearning.NerInferenceOptions)value.Variant, null, null);
				break;
			case "pass_through":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.MachineLearning.PassThroughInferenceOptions)value.Variant, null, null);
				break;
			case "question_answering":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.MachineLearning.QuestionAnsweringInferenceOptions)value.Variant, null, null);
				break;
			case "regression":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.MachineLearning.RegressionInferenceOptions)value.Variant, null, null);
				break;
			case "text_classification":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.MachineLearning.TextClassificationInferenceOptions)value.Variant, null, null);
				break;
			case "text_embedding":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.MachineLearning.TextEmbeddingInferenceOptions)value.Variant, null, null);
				break;
			case "text_expansion":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.MachineLearning.TextExpansionInferenceOptions)value.Variant, null, null);
				break;
			case "zero_shot_classification":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.MachineLearning.ZeroShotClassificationInferenceOptions)value.Variant, null, null);
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.VariantType}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.InferenceConfigCreate)}'.");
		}

		writer.WriteEndObject();
	}
}