// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class IncludeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.Include>
{
	private static readonly System.Text.Json.JsonEncodedText MemberDefinition = System.Text.Json.JsonEncodedText.Encode("definition");
	private static readonly System.Text.Json.JsonEncodedText MemberDefinitionStatus = System.Text.Json.JsonEncodedText.Encode("definition_status");
	private static readonly System.Text.Json.JsonEncodedText MemberFeatureImportanceBaseline = System.Text.Json.JsonEncodedText.Encode("feature_importance_baseline");
	private static readonly System.Text.Json.JsonEncodedText MemberHyperparameters = System.Text.Json.JsonEncodedText.Encode("hyperparameters");
	private static readonly System.Text.Json.JsonEncodedText MemberTotalFeatureImportance = System.Text.Json.JsonEncodedText.Encode("total_feature_importance");

	public override Elastic.Clients.Elasticsearch.MachineLearning.Include Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberDefinition))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.Include.Definition;
		}

		if (reader.ValueTextEquals(MemberDefinitionStatus))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.Include.DefinitionStatus;
		}

		if (reader.ValueTextEquals(MemberFeatureImportanceBaseline))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.Include.FeatureImportanceBaseline;
		}

		if (reader.ValueTextEquals(MemberHyperparameters))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.Include.Hyperparameters;
		}

		if (reader.ValueTextEquals(MemberTotalFeatureImportance))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.Include.TotalFeatureImportance;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberDefinition.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.Include.Definition;
		}

		if (string.Equals(value, MemberDefinitionStatus.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.Include.DefinitionStatus;
		}

		if (string.Equals(value, MemberFeatureImportanceBaseline.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.Include.FeatureImportanceBaseline;
		}

		if (string.Equals(value, MemberHyperparameters.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.Include.Hyperparameters;
		}

		if (string.Equals(value, MemberTotalFeatureImportance.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.Include.TotalFeatureImportance;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.Include)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.Include value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.MachineLearning.Include.Definition:
				writer.WriteStringValue(MemberDefinition);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.Include.DefinitionStatus:
				writer.WriteStringValue(MemberDefinitionStatus);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.Include.FeatureImportanceBaseline:
				writer.WriteStringValue(MemberFeatureImportanceBaseline);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.Include.Hyperparameters:
				writer.WriteStringValue(MemberHyperparameters);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.Include.TotalFeatureImportance:
				writer.WriteStringValue(MemberTotalFeatureImportance);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.Include)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.MachineLearning.Include ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.Include value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}