// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.FrequencyEncodingPreprocessorConverter))]
public sealed partial class FrequencyEncodingPreprocessor
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FrequencyEncodingPreprocessor(string featureName, string field, System.Collections.Generic.IDictionary<string, double> frequencyMap)
	{
		FeatureName = featureName;
		Field = field;
		FrequencyMap = frequencyMap;
	}
#if NET7_0_OR_GREATER
	public FrequencyEncodingPreprocessor()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public FrequencyEncodingPreprocessor()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal FrequencyEncodingPreprocessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public
#if NET7_0_OR_GREATER
	required
#endif
	string FeatureName { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Field { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IDictionary<string, double> FrequencyMap { get; set; }
}

public readonly partial struct FrequencyEncodingPreprocessorDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FrequencyEncodingPreprocessorDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FrequencyEncodingPreprocessorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessorDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessor instance) => new Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessorDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessor(Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessorDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessorDescriptor FeatureName(string value)
	{
		Instance.FeatureName = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessorDescriptor Field(string value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessorDescriptor FrequencyMap(System.Collections.Generic.IDictionary<string, double> value)
	{
		Instance.FrequencyMap = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessorDescriptor FrequencyMap()
	{
		Instance.FrequencyMap = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringDouble.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessorDescriptor FrequencyMap(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringDouble>? action)
	{
		Instance.FrequencyMap = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringDouble.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessorDescriptor AddFrequencyMap(string key, double value)
	{
		Instance.FrequencyMap ??= new System.Collections.Generic.Dictionary<string, double>();
		Instance.FrequencyMap.Add(key, value);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessor Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessorDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessorDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.FrequencyEncodingPreprocessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}