// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.FilterRefConverter))]
public sealed partial class FilterRef
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FilterRef(Elastic.Clients.Elasticsearch.Id filterId)
	{
		FilterId = filterId;
	}
#if NET7_0_OR_GREATER
	public FilterRef()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public FilterRef()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal FilterRef(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The identifier for the filter.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id FilterId { get; set; }

	/// <summary>
	/// <para>
	/// If set to <c>include</c>, the rule applies for values in the filter. If set to <c>exclude</c>, the rule applies for values not in the filter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.FilterType? FilterType { get; set; }
}

public readonly partial struct FilterRefDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.FilterRef Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FilterRefDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.FilterRef instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FilterRefDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.FilterRef(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.FilterRefDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.FilterRef instance) => new Elastic.Clients.Elasticsearch.MachineLearning.FilterRefDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.FilterRef(Elastic.Clients.Elasticsearch.MachineLearning.FilterRefDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The identifier for the filter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.FilterRefDescriptor FilterId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.FilterId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If set to <c>include</c>, the rule applies for values in the filter. If set to <c>exclude</c>, the rule applies for values not in the filter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.FilterRefDescriptor FilterType(Elastic.Clients.Elasticsearch.MachineLearning.FilterType? value)
	{
		Instance.FilterType = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.FilterRef Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.FilterRefDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.FilterRefDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.FilterRef(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}