// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class ExcludeFrequentConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAll = System.Text.Json.JsonEncodedText.Encode("all");
	private static readonly System.Text.Json.JsonEncodedText MemberBy = System.Text.Json.JsonEncodedText.Encode("by");
	private static readonly System.Text.Json.JsonEncodedText MemberNone = System.Text.Json.JsonEncodedText.Encode("none");
	private static readonly System.Text.Json.JsonEncodedText MemberOver = System.Text.Json.JsonEncodedText.Encode("over");

	public override Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAll))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent.All;
		}

		if (reader.ValueTextEquals(MemberBy))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent.By;
		}

		if (reader.ValueTextEquals(MemberNone))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent.None;
		}

		if (reader.ValueTextEquals(MemberOver))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent.Over;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAll.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent.All;
		}

		if (string.Equals(value, MemberBy.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent.By;
		}

		if (string.Equals(value, MemberNone.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent.None;
		}

		if (string.Equals(value, MemberOver.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent.Over;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent.All:
				writer.WriteStringValue(MemberAll);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent.By:
				writer.WriteStringValue(MemberBy);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent.None:
				writer.WriteStringValue(MemberNone);
				break;
			case Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent.Over:
				writer.WriteStringValue(MemberOver);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.ExcludeFrequent value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}