// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.EnsembleConverter))]
public sealed partial class Ensemble
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public Ensemble(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModel> trainedModels)
	{
		TrainedModels = trainedModels;
	}
#if NET7_0_OR_GREATER
	public Ensemble()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public Ensemble()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Ensemble(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutput? AggregateOutput { get; set; }
	public System.Collections.Generic.ICollection<string>? ClassificationLabels { get; set; }
	public System.Collections.Generic.ICollection<string>? FeatureNames { get; set; }
	public string? TargetType { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModel> TrainedModels { get; set; }
}

public readonly partial struct EnsembleDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.Ensemble Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EnsembleDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.Ensemble instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EnsembleDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.Ensemble(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.EnsembleDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.Ensemble instance) => new Elastic.Clients.Elasticsearch.MachineLearning.EnsembleDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.Ensemble(Elastic.Clients.Elasticsearch.MachineLearning.EnsembleDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.MachineLearning.EnsembleDescriptor AggregateOutput(Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutput? value)
	{
		Instance.AggregateOutput = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EnsembleDescriptor AggregateOutput()
	{
		Instance.AggregateOutput = Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutputDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EnsembleDescriptor AggregateOutput(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutputDescriptor>? action)
	{
		Instance.AggregateOutput = Elastic.Clients.Elasticsearch.MachineLearning.AggregateOutputDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EnsembleDescriptor ClassificationLabels(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.ClassificationLabels = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EnsembleDescriptor ClassificationLabels(params string[] values)
	{
		Instance.ClassificationLabels = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EnsembleDescriptor FeatureNames(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.FeatureNames = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EnsembleDescriptor FeatureNames(params string[] values)
	{
		Instance.FeatureNames = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EnsembleDescriptor TargetType(string? value)
	{
		Instance.TargetType = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EnsembleDescriptor TrainedModels(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModel> value)
	{
		Instance.TrainedModels = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EnsembleDescriptor TrainedModels(params Elastic.Clients.Elasticsearch.MachineLearning.TrainedModel[] values)
	{
		Instance.TrainedModels = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EnsembleDescriptor TrainedModels(params System.Action<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDescriptor>?[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.MachineLearning.TrainedModel>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelDescriptor.Build(action));
		}

		Instance.TrainedModels = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.Ensemble Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.EnsembleDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.EnsembleDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.Ensemble(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}